/*
 * Decompiled with CFR 0.152.
 */
package wan;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import java.io.File;
import util.TestException;
import util.TestHelper;
import wan.CacheClientPrms;
import wan.CacheServerPrms;
import wan.WANBlackboard;
import wan.WANClient;

public class WANClientDynamicReg
extends WANClient {
    private static final String REGION_NAME_PARENT = "parent";

    public static void initServerCacheDynamicTask() {
        String cacheConfig = conftab.stringAt(CacheServerPrms.cacheConfig);
        String regionConfig = conftab.stringAt(CacheServerPrms.regionConfig);
        String bridgeConfig = conftab.stringAt(CacheServerPrms.bridgeConfig);
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.configureDynamicRegionFactory(regionConfig);
        client.createCache(cacheConfig);
        client.createRegion(REGION_NAME_PARENT, regionConfig);
        client.startBridgeServer(bridgeConfig);
        client.startQueueMonitor();
        client.createGatewayHub();
    }

    public static void initEdgeClientCacheDynamicTask() {
        String cacheConfig = conftab.stringAt(CacheClientPrms.cacheConfig);
        String regionConfig = conftab.stringAt(CacheClientPrms.regionConfig);
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.configureDynamicRegionFactory(regionConfig);
        client.createCache(cacheConfig);
        client.createRegion(REGION_NAME_PARENT, regionConfig);
    }

    private void configureDynamicRegionFactory(String regionConfig) {
        File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
        d.mkdirs();
        DistributedSystemHelper.connect();
        DynamicRegionFactory.Config config = ClientHelper.getDynamicRegionConfig(d, RegionHelper.getRegionDescription(regionConfig), true, true);
        DynamicRegionFactory.get().open(config);
    }

    public static void putTaskDynamic() {
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.putDynamic("parent/" + REGION_NAME);
    }

    private void createDynamicRegion(String parentName, String drName) {
        Region dr = null;
        try {
            dr = DynamicRegionFactory.get().createDynamicRegion(parentName, drName);
        }
        catch (CacheException ce) {
            throw new TestException(TestHelper.getStackTrace(ce));
        }
        Log.getLogWriter().info("Created dynamic region " + RegionHelper.regionAttributesToString(dr.getAttributes()));
    }

    private void putDynamic(String dynamicRegionPath) {
        Region region = RegionHelper.getRegion(dynamicRegionPath);
        if (region == null) {
            logger.info("Creating dynamic region: " + dynamicRegionPath);
            this.createDynamicRegion(REGION_NAME_PARENT, REGION_NAME);
            region = RegionHelper.getRegion(dynamicRegionPath);
        }
        if (region == null) {
            throw new TestException("Failed to get dynamic region: " + dynamicRegionPath);
        }
        int tid = RemoteTestModule.getCurrentThread().getThreadGroupId();
        logger.info("In putDynamic getThreadGroupId returns: " + tid);
        if (logger.fineEnabled()) {
            int pid = ProcessMgr.getProcessId();
            logger.fine("hydra.ProcessMgr.getProcessId() returns: " + pid);
        }
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            Integer key = new Integer(i);
            Integer val = new Integer(i);
            region.put((Object)key, (Object)val);
            logger.info("Putting into region key: " + key + " val: " + val);
        }
        WANBlackboard.getInstance().getSharedCounters().setIfLarger(WANBlackboard.MaxKeys, tid);
    }

    public static void printTaskDynamic() {
        MasterController.sleepForMs(5000);
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.print("parent/" + REGION_NAME);
    }

    public static void validateTaskDynamic() throws Exception {
        try {
            Thread.interrupted();
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.validate("parent/" + REGION_NAME);
    }

    public static void closeServerCacheDynamicTask() throws Exception {
        Log.getLogWriter().info("Closing server cache");
        WANClientDynamicReg client = new WANClientDynamicReg();
        client.print("parent/" + REGION_NAME);
        client.validate("parent/" + REGION_NAME);
        client.closeCache();
    }

    private void validate(String regionName) throws CacheException {
        Log.getLogWriter().info("Validating cache");
        long size = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.MaxKeys);
        Log.getLogWriter().info("Number of cache entries: " + size);
        Region region = RegionHelper.getRegion(regionName);
        for (int i = 1; i < ITERATIONS; ++i) {
            Integer key = new Integer(i);
            Object val = region.get((Object)key);
            if (val == null) {
                String s = "No value in cache at " + key;
                throw new TestException(s);
            }
            if (val instanceof Integer) {
                Log.getLogWriter().info("Got value: " + (Integer)val + " for key: " + key);
                int ival = (Integer)val;
                if (ival == key) continue;
                String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                throw new TestException(s);
            }
            String s = "Wrong type in cache at " + key + ", expected Integer " + "but got " + val + " of type " + val.getClass().getName();
            throw new TestException(s);
        }
        Log.getLogWriter().info("Validated cache");
    }
}

