/*
 * Decompiled with CFR 0.152.
 */
package wan.ml;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Region;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import wan.ml.Trade;
import wan.ml.TradeLoader;

public class GemFireTradeLoader
extends TradeLoader {
    Region tradeCache = null;
    Object completeNotification = new Object();
    TradeFeederThread feederThread = null;

    public void init(Properties p) {
        this.initTestParams(p);
        this.initLog("TradeLoader_LOG.txt");
        this.feederThread = new TradeFeederThread(this);
        this.feederThread.start();
    }

    public void initTestParams(Properties p) {
        try {
            file_name = p.getProperty("trade_file_location");
            RATE_PER_SECOND = Integer.parseInt(p.getProperty("trades_per_second"));
            START_ROW = Integer.parseInt(p.getProperty("trades_file_start_line"));
            END_ROW = Integer.parseInt(p.getProperty("trades_file_end_line"));
            START_TRADE_ID = Integer.parseInt(p.getProperty("trade_start_id"));
        }
        catch (Exception e) {
            System.out.println("Error getting trade pumping parameters, using defaults: " + e);
            e.printStackTrace();
            RATE_PER_SECOND = 1;
            START_ROW = 1;
            END_ROW = 11;
        }
    }

    public void initLog(String logFileName) {
        try {
            fh = new FileHandler(logFileName);
            logger.addHandler(fh);
            logger.setLevel(Level.ALL);
        }
        catch (Exception e) {
            System.out.println("Could not open log file handle! Exiting . . . ");
            System.exit(0);
        }
    }

    public void start() {
        this.easyPumpTrades();
    }

    @Override
    protected void vendorPublishingAPI(String xml) throws Throwable {
        Trade t = new Trade(xml);
        t.setGFLatencyStart();
        this.tradeCache.put((Object)new Long(t.TradeId), (Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNotification() throws InterruptedException {
        Object object = this.completeNotification;
        synchronized (object) {
            this.completeNotification.wait();
        }
    }

    @Override
    protected void vendorInit(String[] args) throws Throwable {
        System.out.println("DEBUG: End GemFireTradeLoader.vendorInit()");
    }

    private class TradeFeederThread
    extends Thread {
        GemFireTradeLoader loader;

        public TradeFeederThread(GemFireTradeLoader loader) {
            this.loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.loader.easyPumpTrades();
                Object object = GemFireTradeLoader.this.completeNotification;
                synchronized (object) {
                    GemFireTradeLoader.this.completeNotification.notify();
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable e) {
                System.out.println("Thowable Error caught from easyPumpTrades: " + e);
                e.printStackTrace();
            }
        }
    }
}

