/*
 * Decompiled with CFR 0.152.
 */
package wan.ml;

import com.gemstone.gemfire.SystemFailure;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class MarketLoader {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    public static MarketLoader loader;
    private static long start_time;
    private Element root_element;
    protected static int START_TICK_ID;
    private static int currentTickId;
    protected static String file_name;
    protected static int RATE_PER_SECOND;
    protected static long PURE_DELAY;
    protected static int END_ROW;
    protected static int START_ROW;
    protected static int TOTAL_QUOTES;
    private static int CURRENT_ROW;
    private SAXBuilder builder = new SAXBuilder();
    protected static Logger logger;
    protected static FileHandler fh;
    protected Object completeNotification = new Object();

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Did you know about all the args I can take?  they are: -startid -startrow -endrow -rate <filename>");
            System.out.println("Defaults are: 0 Integer.MAX_VALUE 5 Trades.xml");
            try {
                Thread.sleep(5000L);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            for (int x = 0; x < args.length; ++x) {
                System.out.println("args[" + x + "] = " + args[x]);
            }
            System.out.println("logger = " + logger);
            fh = new FileHandler("MarketLoader_LOG.txt");
            loader = (MarketLoader)Class.forName(System.getProperty("vendor.classname")).newInstance();
            loader.vendorInit(args);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable yt) {
            yt.printStackTrace();
            System.exit(1);
        }
        logger.addHandler(fh);
        logger.setLevel(Level.ALL);
        for (int arg = 0; arg < args.length; ++arg) {
            Integer i;
            if ("-rate".equals(args[arg])) {
                i = new Integer(args[++arg]);
                RATE_PER_SECOND = i;
                continue;
            }
            if ("-startrow".equals(args[arg])) {
                i = new Integer(args[++arg]);
                START_ROW = i;
                continue;
            }
            if ("-endrow".equals(args[arg])) {
                i = new Integer(args[++arg]);
                END_ROW = i;
                continue;
            }
            if ("-startid".equals(args[arg])) {
                i = new Integer(args[++arg]);
                START_TICK_ID = i;
                currentTickId = START_TICK_ID - 1;
                continue;
            }
            file_name = args[arg];
        }
        loader.easyPumpMarketChanges();
    }

    protected abstract void vendorInit(String[] var1) throws Throwable;

    protected abstract void vendorPublishingAPI(String var1) throws Throwable;

    protected void easyPumpMarketChanges() {
        String xml2 = null;
        boolean isPureDelayAdjustedForLatency = false;
        int trade_count = 0;
        long lastTime = start_time = System.currentTimeMillis();
        try {
            String line;
            FileReader reader = new FileReader(file_name);
            LineNumberReader line_reader = new LineNumberReader(reader);
            BufferedReader in = new BufferedReader(new LineNumberReader(new FileReader(file_name)));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if ("<XMLROOT>".equals(line) || "</XMLROOT>".equals(line)) continue;
                lines.add(line);
            }
            in.close();
            String[] quotes = lines.toArray(new String[0]);
            int currentQuoteIndex = 0;
            while (trade_count < TOTAL_QUOTES) {
                ArrayList<String> batch = new ArrayList<String>();
                for (int x = 0; x < RATE_PER_SECOND; ++x) {
                    batch.add(quotes[currentQuoteIndex]);
                    if (++currentQuoteIndex != quotes.length) continue;
                    currentQuoteIndex = 0;
                }
                if (PURE_DELAY + lastTime > System.currentTimeMillis()) {
                    Thread.sleep(PURE_DELAY + lastTime - System.currentTimeMillis());
                }
                for (String xml2 : batch) {
                    if (xml2 == null || xml2.equals("")) {
                        System.out.println("MarketData XML String was null! Skipping . . . ");
                        continue;
                    }
                    xml2 = MarketLoader.assignTickId(xml2);
                    long writeStartNanoTime = System.currentTimeMillis();
                    long writeWallStartTime = System.currentTimeMillis();
                    this.vendorPublishingAPI(xml2);
                    this.bracketLog(writeWallStartTime, System.currentTimeMillis() - writeStartNanoTime, xml2);
                    if (++trade_count % 100 != 0 || isPureDelayAdjustedForLatency) continue;
                    long latency = System.currentTimeMillis() - (lastTime + PURE_DELAY);
                    PURE_DELAY -= latency;
                    isPureDelayAdjustedForLatency = true;
                }
                lastTime = System.currentTimeMillis();
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        long end_time = System.currentTimeMillis();
        System.out.println("Processed " + trade_count + " market updates in " + (end_time - start_time) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNotification() throws InterruptedException {
        Object object = this.completeNotification;
        synchronized (object) {
            this.completeNotification.wait();
        }
    }

    private void bracketLog(long writeStartTime, long duration, String xml) {
        Document doc = null;
        duration /= 1000L;
        try {
            StringReader string_reader = new StringReader(xml);
            doc = this.builder.build((Reader)string_reader);
        }
        catch (Exception e) {
            System.out.println("Caught exception during XML parsing");
            e.printStackTrace();
        }
        this.root_element = doc.getRootElement();
        String id = MarketLoader.getStringElement(this.root_element, "TickId");
        String timeStamp = this.formatter.format(new Date(writeStartTime));
    }

    private static String assignTickId(String xml) {
        StringBuffer builder = new StringBuffer(xml);
        int start = builder.indexOf("<TickId>");
        int end = builder.indexOf("</TickId>");
        builder.replace(start, end, "<TickId>" + ++currentTickId);
        return builder.toString();
    }

    private static String getStringElement(Element root_element, String name) {
        return root_element.getChildText(name).trim();
    }

    static {
        START_TICK_ID = 1;
        currentTickId = 0;
        file_name = "MarketData.xml";
        RATE_PER_SECOND = 5;
        PURE_DELAY = 1000L;
        END_ROW = Integer.MAX_VALUE;
        START_ROW = 0;
        TOTAL_QUOTES = 0;
        CURRENT_ROW = 0;
        logger = Logger.getLogger("com.ml.MarketLoader");
        fh = null;
    }
}

