/*
 * Decompiled with CFR 0.152.
 */
package wan.ml;

import com.gemstone.gemfire.SystemFailure;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class TradeLoader {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    protected static long start_time;
    private Element root_element;
    protected static int START_TRADE_ID;
    private static int currentTradeId;
    protected static String file_name;
    protected static int RATE_PER_SECOND;
    protected static long PURE_DELAY;
    protected static int END_ROW;
    protected static int START_ROW;
    protected static int CURRENT_ROW;
    private SAXBuilder builder = new SAXBuilder();
    protected static Logger logger;
    protected static FileHandler fh;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Did you know about all the args I can take?  they are: -startid -startrow -endrow -rate <filename>");
            System.out.println("Defaults are: 0 Integer.MAX_VALUE 5 Trades.xml");
            try {
                Thread.sleep(5000L);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            for (int x = 0; x < args.length; ++x) {
                System.out.println("args[" + x + "] = " + args[x]);
            }
            System.out.println("logger = " + logger);
            fh = new FileHandler("TradeLoader_LOG.txt");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable yt) {
            yt.printStackTrace();
            System.exit(1);
        }
        logger.addHandler(fh);
        logger.setLevel(Level.ALL);
        for (int arg = 0; arg < args.length; ++arg) {
            Integer i;
            if ("-rate".equals(args[arg])) {
                i = new Integer(args[++arg]);
                RATE_PER_SECOND = i;
                continue;
            }
            if ("-startrow".equals(args[arg])) {
                i = new Integer(args[++arg]);
                START_ROW = i;
                continue;
            }
            if ("-endrow".equals(args[arg])) {
                i = new Integer(args[++arg]);
                END_ROW = i;
                continue;
            }
            if ("-startid".equals(args[arg])) {
                i = new Integer(args[++arg]);
                START_TRADE_ID = i;
                currentTradeId = START_TRADE_ID - 1;
                continue;
            }
            file_name = args[arg];
        }
    }

    protected abstract void vendorInit(String[] var1) throws Throwable;

    protected abstract void vendorPublishingAPI(String var1) throws Throwable;

    protected void easyPumpTrades() {
        int trade_count;
        block9: {
            String xml2 = null;
            boolean isPureDelayAdjustedForLatency = false;
            trade_count = 0;
            long lastTime = start_time = System.currentTimeMillis();
            try {
                LineNumberReader line_reader = new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file_name))));
                line_reader.setLineNumber(START_ROW);
                while (true) {
                    ArrayList<String> batch = new ArrayList<String>();
                    for (int x = 0; x < RATE_PER_SECOND; ++x) {
                        xml2 = line_reader.readLine();
                        if (null == xml2) {
                            logger.warning("The XML is null at line number " + line_reader.getLineNumber());
                            long end_time = System.currentTimeMillis();
                            System.out.println("Processed " + trade_count + " trades in " + (end_time - start_time) + " millies.");
                            System.exit(0);
                        }
                        if ("<XMLROOT>".equals(xml2) || line_reader.getLineNumber() < START_ROW) continue;
                        if (!"</XMLROOT>".equals(xml2) && line_reader.getLineNumber() <= END_ROW) {
                            batch.add(xml2);
                            continue;
                        }
                        break block9;
                    }
                    if (PURE_DELAY + lastTime > System.currentTimeMillis()) {
                        Thread.sleep(PURE_DELAY + lastTime - System.currentTimeMillis());
                    }
                    for (String xml2 : batch) {
                        xml2 = TradeLoader.assignTradeId(xml2);
                        long writeStartNanoTime = System.currentTimeMillis();
                        long writeWallStartTime = System.currentTimeMillis();
                        this.vendorPublishingAPI(xml2);
                        this.bracketLog(writeWallStartTime, System.currentTimeMillis() - writeStartNanoTime, xml2);
                        if (++trade_count % 100 != 0 || isPureDelayAdjustedForLatency) continue;
                        long latency = System.currentTimeMillis() - (lastTime + PURE_DELAY);
                        PURE_DELAY -= latency;
                        isPureDelayAdjustedForLatency = true;
                    }
                    lastTime = System.currentTimeMillis();
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable e) {
                System.out.println("Caught exception in easyPumpTrades");
                e.printStackTrace();
            }
        }
        long end_time = System.currentTimeMillis();
        System.out.println("Processed " + trade_count + " trades in " + (end_time - start_time) + " ms.");
    }

    protected void bracketLog(long writeStartTime, long duration, String xml) {
        Document doc = null;
        duration /= 1000L;
        try {
            StringReader string_reader = new StringReader(xml);
            doc = this.builder.build((Reader)string_reader);
        }
        catch (Exception e) {
            System.out.println("Caught exception during XML parsing");
            e.printStackTrace();
        }
        this.root_element = doc.getRootElement();
        String id = TradeLoader.getStringElement(this.root_element, "TradeId");
        String region = TradeLoader.getStringElement(this.root_element, "Entity");
        String timeStamp = this.formatter.format(new Date(writeStartTime));
    }

    protected static String assignTradeId(String xml) {
        StringBuffer builder = new StringBuffer(xml);
        int start = builder.indexOf("<TradeId>");
        int end = builder.indexOf("</TradeId>");
        builder.replace(start, end, "<TradeId>" + ++currentTradeId);
        return builder.toString();
    }

    private static String getStringElement(Element root_element, String name) {
        return root_element.getChildText(name).trim();
    }

    static {
        START_TRADE_ID = 1;
        currentTradeId = 0;
        file_name = "Trades.xml";
        RATE_PER_SECOND = 5;
        PURE_DELAY = 1000L;
        END_ROW = Integer.MAX_VALUE;
        START_ROW = 0;
        CURRENT_ROW = 0;
        logger = Logger.getLogger("com.ml.TradeLoader");
        fh = null;
    }
}

