/*
 * Decompiled with CFR 0.152.
 */
package com.google.polo.pairing;

import java.nio.charset.Charset;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String dumpHexString(byte[] array) {
        return HexDump.dumpHexString(array, 0, array.length);
    }

    public static String dumpHexString(byte[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[16];
        int lineIndex = 0;
        result.append("\n0x").append(HexDump.toHexString(offset));
        for (int i = offset; i < offset + length; ++i) {
            if (lineIndex == 16) {
                result.append(" ");
                for (int j = 0; j < 16; ++j) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1, Charset.forName("UTF-8")));
                        continue;
                    }
                    result.append(".");
                }
                result.append("\n0x");
                result.append(HexDump.toHexString(i));
                lineIndex = 0;
            }
            byte b = array[i];
            result.append(" ");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            line[lineIndex++] = b;
        }
        if (lineIndex != 16) {
            int i;
            int count = (16 - lineIndex) * 3;
            ++count;
            for (i = 0; i < count; ++i) {
                result.append(" ");
            }
            for (i = 0; i < lineIndex; ++i) {
                if (line[i] > 32 && line[i] < 126) {
                    result.append(new String(line, i, 1));
                    continue;
                }
                result.append(".");
            }
        }
        return result.toString();
    }

    public static String toHexString(byte b) {
        return HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexString(boolean prefix, byte[] array) {
        return HexDump.toHexString(prefix, array, 0, array.length);
    }

    public static String toHexString(byte[] array) {
        return HexDump.toHexString(true, array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        return HexDump.toHexString(true, array, offset, length);
    }

    public static String toHexString(boolean prefix, byte[] array, int offset, int length) {
        char[] buf;
        int bufIndex = 0;
        if (prefix) {
            buf = new char[2 + length * 2];
            buf[0] = 48;
            buf[1] = 120;
            bufIndex = 2;
        } else {
            buf = new char[length * 2];
        }
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array = new byte[]{b};
        return array;
    }

    public static byte[] toByteArray(int i) {
        byte[] array = new byte[4];
        array[3] = (byte)(i & 0xFF);
        array[2] = (byte)(i >> 8 & 0xFF);
        array[1] = (byte)(i >> 16 & 0xFF);
        array[0] = (byte)(i >> 24 & 0xFF);
        return array;
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(HexDump.toByte(hexString.charAt(i)) << 4 | HexDump.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }
}

