/*
 * Decompiled with CFR 0.152.
 */
package io.snice.functional;

import io.snice.preconditions.PreConditions;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Either<L, R> {
    public <U> U fold(Function<? super L, ? extends U> var1, Function<? super R, ? extends U> var2);

    public void accept(Consumer<? super L> var1, Consumer<? super R> var2);

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public static <L, R> Left<L, R> left(L value) {
        return new Left(value);
    }

    default public boolean isRight() {
        return false;
    }

    default public boolean isLeft() {
        return false;
    }

    default public R get() {
        throw new IllegalArgumentException("Unable to get a Right on a Left");
    }

    default public L getLeft() {
        throw new IllegalArgumentException("Unable to get a Left on a Right");
    }

    public static class Left<L, R>
    implements Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
            PreConditions.assertNotNull(leftMapper, "The left mapper cannot be null");
            return leftMapper.apply(this.value);
        }

        @Override
        public void accept(Consumer<? super L> leftConsumer, Consumer<? super R> rightConsumer) {
            PreConditions.assertNotNull(leftConsumer, "The left consumer cannot be null");
            leftConsumer.accept(this.value);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return this.value.equals(left.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Right<L, R>
    implements Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
            PreConditions.assertNotNull(rightMapper, "The right mapper cannot be null");
            return rightMapper.apply(this.value);
        }

        @Override
        public void accept(Consumer<? super L> leftConsumer, Consumer<? super R> rightConsumer) {
            PreConditions.assertNotNull(rightConsumer, "The right consumer cannot be null");
            rightConsumer.accept(this.value);
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public R get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return this.value.equals(right.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

