/*
 * Decompiled with CFR 0.152.
 */
package io.snice.net;

import io.snice.preconditions.PreConditions;

public class IPv4 {
    private static final String ERROR_MSG_ILLEGAL_FORMAT = "Illegal format. Expected the address to be in format \"a.b.c.d\"";

    public static String convertToStringIP(byte[] ip) {
        PreConditions.assertArray(ip, 0, 4);
        short a = (short)(ip[0] & 0xFF);
        short b = (short)(ip[1] & 0xFF);
        short c = (short)(ip[2] & 0xFF);
        short d = (short)(ip[3] & 0xFF);
        return a + "." + b + "." + c + "." + d;
    }

    public static String convertToStringIP(byte a, byte b, byte c, byte d) {
        return (short)(a & 0xFF) + "." + (short)(b & 0xFF) + "." + (short)(c & 0xFF) + "." + (short)(d & 0xFF);
    }

    public static byte[] fromString(String str) {
        byte[] buffer = new byte[4];
        return IPv4.fromString(buffer, 0, str);
    }

    public static byte[] fromString(byte[] dst, int offset, String str) {
        PreConditions.assertNotEmpty(str, "The IP address cannot be null or the empty string");
        PreConditions.assertArray(dst, offset, 4, "There are not enough bytes available in the destination byte-array");
        String[] parts = str.split("\\.");
        PreConditions.assertArgument(parts.length == 4, ERROR_MSG_ILLEGAL_FORMAT);
        dst[offset + 0] = (byte)Short.parseShort(parts[0]);
        dst[offset + 1] = (byte)Short.parseShort(parts[1]);
        dst[offset + 2] = (byte)Short.parseShort(parts[2]);
        dst[offset + 3] = (byte)Short.parseShort(parts[3]);
        return dst;
    }
}

