/*
 * Decompiled with CFR 0.152.
 */
package io.snice.preconditions;

import java.util.Collection;

public final class PreConditions {
    private PreConditions() {
    }

    public static <T> void assertNull(T reference, String msg) throws IllegalArgumentException {
        if (reference != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> void assertNull(T reference) throws IllegalArgumentException {
        PreConditions.assertNull(reference, "Value must be null");
    }

    public static <T> T assertNotNull(T reference, String msg) throws IllegalArgumentException {
        if (reference == null) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T assertNotNull(T reference) throws IllegalArgumentException {
        return PreConditions.assertNotNull(reference, "Value cannot be null");
    }

    public static String assertNotEmpty(String reference) throws IllegalArgumentException {
        return PreConditions.assertNotEmpty(reference, "The argument cannot be null or the empty string");
    }

    public static String assertNotEmpty(String reference, String msg) throws IllegalArgumentException {
        if (reference == null || reference.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> Collection<T> assertCollectionNotEmpty(Collection<T> reference) throws IllegalArgumentException {
        return PreConditions.assertCollectionNotEmpty(reference, "The argument cannot be null or an empty collection");
    }

    public static <T> Collection<T> assertCollectionNotEmpty(Collection<T> reference, String msg) throws IllegalArgumentException {
        if (reference == null || reference.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static void assertArgument(boolean expression, String msg) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertArgument(boolean expression) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertArray(byte[] array, int offset, int length, String msg) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(msg);
        }
        PreConditions.assertArrayBoundaries(array.length, offset, length, msg);
    }

    public static void assertArrayNotEmpty(Object[] array) throws IllegalArgumentException {
        PreConditions.assertArrayNotEmpty(array, "The given array cannot be null or the empty array");
    }

    public static void assertArrayNotEmpty(Object[] array, String msg) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertArray(byte[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException("The byte array cannot be null");
        }
        PreConditions.assertArray(array, 0, array.length);
    }

    private static void assertArrayBoundaries(int arraySize, int offset, int length, String msg) throws IllegalArgumentException {
        if (length > arraySize || offset < 0 || offset != 0 && offset >= arraySize || offset + length > arraySize || length < 0) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertArray(byte[] array, int offset, int length) throws IllegalArgumentException {
        PreConditions.assertArray(array, offset, length, "The byte-array and the offset and/or length does not match up");
    }

    public static <T> T ensureNotNull(T reference, String msg) throws IllegalArgumentException {
        if (reference == null) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNotNull(T reference) throws IllegalArgumentException {
        if (reference == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return reference;
    }

    public static String ensureNotEmpty(String reference, String msg) throws IllegalArgumentException {
        if (reference == null || reference.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
        return reference;
    }

    public static boolean checkIfEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean checkIfNotEmpty(String string) {
        return !PreConditions.checkIfEmpty(string);
    }

    public static <T> T ifNull(T reference, T defaultValue) {
        if (reference == null) {
            return defaultValue;
        }
        return reference;
    }
}

