/*
 * Decompiled with CFR 0.152.
 */
package io.snice.preconditions;

import io.snice.preconditions.PreConditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface ValidationError<T> {
    public static <T> ValidationError<T> of(T error) {
        PreConditions.assertNotNull(error);
        return new DefaultValidationError<T>(List.of(error));
    }

    public static <T> ValidationError<T> of(T ... errors) {
        PreConditions.assertNotNull(errors);
        PreConditions.assertArgument(errors.length > 0, "The list of errors cannot be empty");
        return new DefaultValidationError<T>(List.of(errors));
    }

    public static <T> ValidationError<T> append(ValidationError<T> v, T error) {
        if (v == null) {
            return ValidationError.of(error);
        }
        return v.append(error);
    }

    public List<T> getErrors();

    public ValidationError append(T ... var1);

    public static class DefaultValidationError<T>
    implements ValidationError<T> {
        private final List<T> errors;

        private DefaultValidationError(List<T> errors) {
            this.errors = errors;
        }

        @Override
        public List<T> getErrors() {
            return this.errors;
        }

        @Override
        public ValidationError<T> append(T ... errors) {
            if (errors == null || errors.length == 0) {
                return this;
            }
            ArrayList<T> l = new ArrayList<T>(this.errors);
            for (int i = 0; i < errors.length; ++i) {
                l.add(errors[i]);
            }
            return new DefaultValidationError<T>(Collections.unmodifiableList(l));
        }
    }
}

