/*
 * Decompiled with CFR 0.152.
 */
package io.snice.protocol;

import io.snice.preconditions.PreConditions;
import io.snice.protocol.Request;
import io.snice.protocol.Response;
import io.snice.protocol.ResponseSupport;
import io.snice.protocol.TransactionId;
import io.snice.protocol.TransactionSupport;
import java.util.Optional;

public class RequestSupport<O, T>
extends TransactionSupport<O, T>
implements Request<O, T> {
    protected RequestSupport(TransactionId transactionId, O owner, Optional<T> payload) {
        super(transactionId, owner, payload);
    }

    protected RequestSupport(TransactionId transactionId, O owner) {
        super(transactionId, owner);
    }

    protected RequestSupport(O owner) {
        super(TransactionId.generateDefault(), owner);
    }

    protected RequestSupport(O owner, T payload) {
        super(TransactionId.generateDefault(), owner, Optional.of(payload));
    }

    public static <O> RequestSupport<O, Object> create(O owner) {
        PreConditions.assertNotNull(owner);
        return new RequestSupport(owner);
    }

    public static <O, T> RequestSupport<O, T> create(O owner, T payload) {
        PreConditions.assertNotNull(owner);
        PreConditions.assertNotNull(payload);
        return new RequestSupport<O, T>(owner, payload);
    }

    public static <O, T> BuilderSupport<O, T> of(O owner, T payload) {
        PreConditions.assertNotNull(owner);
        PreConditions.assertNotNull(payload);
        return new BuilderSupport<O, T>(owner, Optional.of(payload));
    }

    public static <O> BuilderSupport<O, Object> of(O owner) {
        PreConditions.assertNotNull(owner);
        return new BuilderSupport(owner, Optional.empty());
    }

    @Override
    public Response.Builder<O, Object> buildResponse() {
        return new ResponseSupport.BuilderSupport(this.getTransactionId(), this.getOwner(), Optional.empty());
    }

    @Override
    public <T1> Response.Builder<O, T1> buildResponse(T1 payload) {
        PreConditions.assertNotNull(payload);
        return new ResponseSupport.BuilderSupport(this.getTransactionId(), this.getOwner(), Optional.of(payload));
    }

    @Override
    public Response<O, Object> createResponse() {
        return new ResponseSupport.BuilderSupport(this.getTransactionId(), this.getOwner(), Optional.empty()).build();
    }

    public static class BuilderSupport<O, T>
    implements Request.Builder<O, T> {
        private final O owner;
        private final Optional<T> payload;
        private TransactionId transactionId;

        protected BuilderSupport(O owner, Optional<T> payload) {
            this.owner = owner;
            this.payload = payload;
        }

        @Override
        public Request.Builder<O, T> withTransactionId(TransactionId transactionId) {
            PreConditions.assertNotNull(transactionId);
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public Request<O, T> build() {
            TransactionId id = this.transactionId == null ? TransactionId.generateDefault() : this.transactionId;
            return this.internalBuild(id, this.owner, this.payload);
        }

        protected Request<O, T> internalBuild(TransactionId id, O owner, Optional<T> payload) {
            return new RequestSupport<O, T>(id, owner, payload);
        }
    }
}

