/*
 * Decompiled with CFR 0.152.
 */
package io.snice.protocol;

import io.snice.protocol.Response;
import io.snice.protocol.TransactionId;
import io.snice.protocol.TransactionSupport;
import java.util.Optional;

public class ResponseSupport<O, T>
extends TransactionSupport<O, T>
implements Response<O, T> {
    private final boolean isFinal;

    protected ResponseSupport(TransactionId transactionId, O owner, boolean isFinal, Optional<T> payload) {
        super(transactionId, owner, payload);
        this.isFinal = isFinal;
    }

    protected ResponseSupport(TransactionId transactionId, O owner, boolean isFinal) {
        super(transactionId, owner);
        this.isFinal = isFinal;
    }

    protected ResponseSupport(TransactionId transactionId, O owner) {
        super(transactionId, owner);
        this.isFinal = true;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    public static class BuilderSupport<O, T>
    implements Response.Builder<O, T> {
        private final TransactionId transactionId;
        private final O owner;
        private final Optional<T> payload;
        private boolean isFinal = true;

        protected BuilderSupport(TransactionId transactionId, O owner, Optional<T> payload) {
            this.transactionId = transactionId;
            this.owner = owner;
            this.payload = payload;
        }

        @Override
        public Response.Builder<O, T> isFinal(boolean value) {
            this.isFinal = value;
            return this;
        }

        @Override
        public final Response<O, T> build() {
            return this.internalBuild(this.transactionId, this.owner, this.payload, this.isFinal);
        }

        protected Response<O, T> internalBuild(TransactionId id, O owner, Optional<T> payload, boolean isFinal) {
            return new ResponseSupport<O, T>(id, owner, isFinal, payload);
        }
    }
}

