/*
 * Decompiled with CFR 0.152.
 */
package io.snice.util.concurrent;

import io.snice.preconditions.PreConditions;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SniceThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final int priority;
    private final Optional<Boolean> isDaemon;

    public static Builder withNamePrefix(String namePrefix) {
        PreConditions.assertNotEmpty(namePrefix, "The prefix of the thread name cannot be null or the empty string");
        return new Builder(namePrefix);
    }

    private SniceThreadFactory(String prefix, ThreadGroup group, int priority, Optional<Boolean> isDaemon) {
        this.group = group;
        this.namePrefix = prefix;
        this.priority = priority;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        this.isDaemon.ifPresent(t::setDaemon);
        t.setPriority(this.priority);
        return t;
    }

    public static class Builder {
        private final String prefix;
        private ThreadGroup group;
        private int priority = -1;
        private Boolean isDaemon;

        private Builder(String prefix) {
            this.prefix = prefix;
        }

        public Builder withDaemon(boolean isDaemon) {
            this.isDaemon = isDaemon;
            return this;
        }

        public Builder withThreadGroup(ThreadGroup group) {
            PreConditions.assertNotNull(group);
            this.group = group;
            return this;
        }

        public Builder withPriority(int priority) {
            PreConditions.assertArgument(priority > 0 && priority <= 10, "The thread priority must be within 0 to 10");
            this.priority = priority;
            return this;
        }

        public ThreadFactory build() {
            return new SniceThreadFactory(this.prefix, this.ensureThreadGroup(), this.ensurePriority(), Optional.ofNullable(this.isDaemon));
        }

        private ThreadGroup ensureThreadGroup() {
            return this.group != null ? this.group : Thread.currentThread().getThreadGroup();
        }

        private int ensurePriority() {
            return this.priority == -1 ? 5 : this.priority;
        }
    }
}

