/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.sniffy.SpyConfiguration;
import io.sniffy.ThreadMetaData;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.socket.NetworkPacket;
import io.sniffy.socket.SocketMetaData;
import io.sniffy.socket.SocketStats;
import io.sniffy.sql.SqlStats;
import io.sniffy.sql.StatementMetaData;
import java.util.Deque;
import java.util.LinkedList;

public abstract class BaseSpy<C extends BaseSpy<C>> {
    private final SpyConfiguration spyConfiguration;
    protected volatile ConcurrentLinkedHashMap<StatementMetaData, SqlStats> executedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    protected volatile ConcurrentLinkedHashMap<SocketMetaData, SocketStats> socketOperations = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    protected volatile ConcurrentLinkedHashMap<SocketMetaData, Deque<NetworkPacket>> networkTraffic = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    protected volatile ConcurrentLinkedHashMap<SocketMetaData, Deque<NetworkPacket>> decryptedNetworkTraffic = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();

    protected void addNetworkTraffic(SocketMetaData socketMetaData, boolean sent, long timestamp, String stackTrace, ThreadMetaData threadMetaData, byte[] traffic, int off, int len) {
        NetworkPacket lastPacket;
        LinkedList<NetworkPacket> networkPackets = (LinkedList<NetworkPacket>)this.networkTraffic.get((Object)socketMetaData);
        if (null == networkPackets) {
            networkPackets = new LinkedList<NetworkPacket>();
            this.networkTraffic.putIfAbsent((Object)socketMetaData, networkPackets);
        }
        if (null == (lastPacket = (NetworkPacket)networkPackets.peekLast()) || !lastPacket.combine(sent, timestamp, stackTrace, threadMetaData, traffic, off, len, SniffyConfiguration.INSTANCE.getPacketMergeThreshold())) {
            networkPackets.add(new NetworkPacket(sent, timestamp, stackTrace, threadMetaData, traffic, off, len));
        }
    }

    protected void addDecryptedNetworkTraffic(SocketMetaData socketMetaData, boolean sent, long timestamp, String stackTrace, ThreadMetaData threadMetaData, byte[] traffic, int off, int len) {
        NetworkPacket lastPacket;
        LinkedList<NetworkPacket> networkPackets = (LinkedList<NetworkPacket>)this.decryptedNetworkTraffic.get((Object)socketMetaData);
        if (null == networkPackets) {
            networkPackets = new LinkedList<NetworkPacket>();
            this.decryptedNetworkTraffic.putIfAbsent((Object)socketMetaData, networkPackets);
        }
        if (null == (lastPacket = (NetworkPacket)networkPackets.peekLast()) || !lastPacket.combine(sent, timestamp, stackTrace, threadMetaData, traffic, off, len, SniffyConfiguration.INSTANCE.getPacketMergeThreshold())) {
            networkPackets.add(new NetworkPacket(sent, timestamp, stackTrace, threadMetaData, traffic, off, len));
        }
    }

    protected BaseSpy(SpyConfiguration spyConfiguration) {
        this.spyConfiguration = spyConfiguration;
    }

    public C reset() {
        this.resetExecutedStatements();
        this.resetSocketOpertions();
        return this.self();
    }

    protected C self() {
        return (C)this;
    }

    protected SpyConfiguration getSpyConfiguration() {
        return this.spyConfiguration;
    }

    protected void resetExecutedStatements() {
        this.executedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    }

    protected void resetSocketOpertions() {
        this.socketOperations = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    }

    protected void addExecutedStatement(StatementMetaData statementMetaData, long elapsedTime, int bytesDown, int bytesUp, int rowsUpdated) {
        SqlStats sqlStats = (SqlStats)this.executedStatements.get((Object)statementMetaData);
        if (null == sqlStats) {
            sqlStats = (SqlStats)this.executedStatements.putIfAbsent((Object)statementMetaData, (Object)new SqlStats(elapsedTime, bytesDown, bytesUp, rowsUpdated, 1));
        }
        if (null != sqlStats) {
            sqlStats.accumulate(elapsedTime, bytesDown, bytesUp, rowsUpdated, 1);
        }
    }

    protected void addReturnedRow(StatementMetaData statementMetaData) {
        SqlStats sqlStats = (SqlStats)this.executedStatements.get((Object)statementMetaData);
        if (null != sqlStats) {
            sqlStats.accumulate(0L, 0, 0, 1, 0);
        }
    }

    protected void addSocketOperation(SocketMetaData socketMetaData, long elapsedTime, int bytesDown, int bytesUp) {
        SocketStats socketStats = (SocketStats)this.socketOperations.get((Object)socketMetaData);
        if (null == socketStats) {
            socketStats = (SocketStats)this.socketOperations.putIfAbsent((Object)socketMetaData, (Object)new SocketStats(elapsedTime, bytesDown, bytesUp));
        }
        if (null != socketStats) {
            socketStats.accumulate(elapsedTime, bytesDown, bytesUp);
        }
    }
}

