/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy;

import com.codahale.metrics.Timer;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.sniffy.BaseSpy;
import io.sniffy.CurrentThreadSpy;
import io.sniffy.Executable;
import io.sniffy.Sniffer;
import io.sniffy.Spy;
import io.sniffy.SpyConfiguration;
import io.sniffy.ThreadMetaData;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.SnifferSocketImplFactory;
import io.sniffy.socket.SocketMetaData;
import io.sniffy.socket.SocketStats;
import io.sniffy.sql.SqlStatement;
import io.sniffy.sql.SqlUtil;
import io.sniffy.sql.StatementMetaData;
import io.sniffy.util.StackTraceExtractor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Sniffy {
    private static final Polyglog LOG = PolyglogFactory.log(Sniffy.class);
    public static final int TOP_SQL_CAPACITY = 1024;
    private static volatile boolean hasGlobalSpies = false;
    private static volatile boolean hasThreadLocalSpies = false;
    protected static final Queue<WeakReference<Spy>> registeredSpies = new ConcurrentLinkedQueue<WeakReference<Spy>>();
    protected static final ConcurrentMap<Long, WeakReference<CurrentThreadSpy>> currentThreadSpies = new ConcurrentHashMap<Long, WeakReference<CurrentThreadSpy>>();
    protected static volatile ConcurrentLinkedHashMap<String, Timer> globalSqlStats = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)SniffyConfiguration.INSTANCE.getTopSqlCapacity()).build();
    private static final ThreadLocal<SocketStats> socketStatsAccumulator = new ThreadLocal();
    public static final AtomicInteger CONNECTION_ID_SEQUENCE = new AtomicInteger();
    private static volatile boolean initialized = false;
    private static volatile boolean nioModuleLoaded;
    private static volatile boolean tlsModuleLoaded;

    protected Sniffy() {
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        LOG.info("Initializing Sniffy 3.1.11");
        SniffyConfiguration.INSTANCE.addTopSqlCapacityListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ConcurrentLinkedHashMap<String, Timer> oldValues = globalSqlStats;
                globalSqlStats = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)SniffyConfiguration.INSTANCE.getTopSqlCapacity()).build();
                globalSqlStats.putAll(oldValues);
            }
        });
        if (SniffyConfiguration.INSTANCE.isMonitorSocket()) {
            LOG.info("Socket monitoring enabled - installing SnifferSocketImplFactory");
            try {
                SnifferSocketImplFactory.install();
            }
            catch (IOException e) {
                LOG.error("Couldn't install SnifferSocketImplFactory", e);
            }
        } else {
            LOG.debug("Socket monitoring disabled - installing hook on SniffyConfiguration.INSTANCE.monitorSocket property");
            SniffyConfiguration.INSTANCE.addMonitorSocketListener(new PropertyChangeListener(){
                private boolean sniffySocketImplFactoryInstalled = false;

                @Override
                public synchronized void propertyChange(PropertyChangeEvent evt) {
                    if (this.sniffySocketImplFactoryInstalled) {
                        return;
                    }
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        LOG.info("Socket monitoring enabled - installing SnifferSocketImplFactory");
                        try {
                            SnifferSocketImplFactory.install();
                            this.sniffySocketImplFactoryInstalled = true;
                        }
                        catch (IOException e) {
                            LOG.error("Couldn't install SnifferSocketImplFactory", e);
                        }
                    }
                }
            });
        }
        if (SniffyConfiguration.INSTANCE.isMonitorNio()) {
            LOG.info("NIO monitoring enabled - loading NIO Sniffy Module");
            Sniffy.loadNioModule();
        } else {
            SniffyConfiguration.INSTANCE.addMonitorNioListener(new PropertyChangeListener(){
                private boolean sniffySelectorProviderInstalled = false;

                @Override
                public synchronized void propertyChange(PropertyChangeEvent evt) {
                    if (this.sniffySelectorProviderInstalled) {
                        return;
                    }
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        LOG.info("NIO monitoring enabled - loading NIO Sniffy Module");
                        Sniffy.loadNioModule();
                        this.sniffySelectorProviderInstalled = true;
                    }
                }
            });
        }
        if (SniffyConfiguration.INSTANCE.isDecryptTls()) {
            LOG.info("TLS decryption enabled - loading TLS Sniffy Module");
            Sniffy.loadTlsModule();
        } else {
            SniffyConfiguration.INSTANCE.addDecryptTlsListener(new PropertyChangeListener(){
                private boolean sniffyTlsModuleInstalled = false;

                @Override
                public synchronized void propertyChange(PropertyChangeEvent evt) {
                    if (this.sniffyTlsModuleInstalled) {
                        return;
                    }
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        LOG.info("TLS decryption enabled - loading TLS Sniffy Module");
                        Sniffy.loadTlsModule();
                        this.sniffyTlsModuleInstalled = true;
                    }
                }
            });
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadNioModule() {
        if (nioModuleLoaded) return;
        Class<Sniffy> clazz = Sniffy.class;
        synchronized (Sniffy.class) {
            if (nioModuleLoaded) return;
            try {
                Class.forName("io.sniffy.nio.SniffySelectorProviderModule").getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
                Class.forName("io.sniffy.nio.compat.SniffyCompatSelectorProviderModule").getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.error(e);
            }
            nioModuleLoaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadTlsModule() {
        if (tlsModuleLoaded) return;
        Class<Sniffy> clazz = Sniffy.class;
        synchronized (Sniffy.class) {
            if (tlsModuleLoaded) return;
            try {
                Class.forName("io.sniffy.tls.SniffyTlsModule").getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.error(e);
            }
            tlsModuleLoaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void logSqlTime(String sql, long elapsedTime) {
        if (SniffyConfiguration.INSTANCE.getTopSqlCapacity() <= 0) {
            return;
        }
        String normalizedSql = SqlUtil.normalizeInStatement(sql);
        Timer timer = (Timer)globalSqlStats.get((Object)normalizedSql);
        if (null == timer) {
            Timer newTimer = new Timer();
            newTimer.update(elapsedTime, TimeUnit.MILLISECONDS);
            timer = (Timer)globalSqlStats.putIfAbsent((Object)normalizedSql, (Object)newTimer);
        }
        if (null != timer) {
            timer.update(elapsedTime, TimeUnit.MILLISECONDS);
        }
    }

    public static ConcurrentMap<String, Timer> getGlobalSqlStats() {
        return globalSqlStats;
    }

    protected static WeakReference<Spy> registerSpy(Spy spy) {
        LOG.trace("Registered new global Spy " + spy);
        hasGlobalSpies = true;
        WeakReference<Spy> spyReference = new WeakReference<Spy>(spy);
        registeredSpies.add(spyReference);
        return spyReference;
    }

    protected static WeakReference<CurrentThreadSpy> registerCurrentThreadSpy(CurrentThreadSpy spy) {
        LOG.trace("Registered new ThreadLocal Spy " + spy);
        hasThreadLocalSpies = true;
        WeakReference<CurrentThreadSpy> spyReference = new WeakReference<CurrentThreadSpy>(spy);
        currentThreadSpies.put(Thread.currentThread().getId(), spyReference);
        return spyReference;
    }

    protected static void removeSpyReference(WeakReference<Spy> spyReference) {
        LOG.trace("Removing global Spy reference" + spyReference);
        registeredSpies.remove(spyReference);
    }

    protected static void removeCurrentThreadSpyReference() {
        WeakReference removed = (WeakReference)currentThreadSpies.remove(Thread.currentThread().getId());
        LOG.trace("Removed ThreadLocal Spy reference " + removed);
    }

    private static Iterable<BaseSpy<?>> getEffectiveSpyList() {
        return new Iterable<BaseSpy<?>>(){

            @Override
            public Iterator<BaseSpy<?>> iterator() {
                return new Iterator<BaseSpy<?>>(){
                    private BaseSpy<?> next;
                    private final Iterator<WeakReference<Spy>> globalSpiesIterator = registeredSpies.iterator();
                    private boolean globalSpiesChecked;
                    private boolean threadLocalSpiesChecked;

                    @Override
                    public boolean hasNext() {
                        Long threadId;
                        WeakReference spyReference;
                        if (!this.globalSpiesChecked) {
                            if (hasGlobalSpies) {
                                while (this.globalSpiesIterator.hasNext()) {
                                    WeakReference<Spy> spyReference2 = this.globalSpiesIterator.next();
                                    Spy spy = (Spy)spyReference2.get();
                                    if (null == spy) {
                                        this.globalSpiesIterator.remove();
                                        continue;
                                    }
                                    this.next = spy;
                                    return true;
                                }
                            }
                            this.globalSpiesChecked = true;
                        }
                        if (!this.threadLocalSpiesChecked && hasThreadLocalSpies && null != (spyReference = (WeakReference)currentThreadSpies.get(threadId = Long.valueOf(Thread.currentThread().getId())))) {
                            CurrentThreadSpy spy = (CurrentThreadSpy)spyReference.get();
                            if (null == spy) {
                                currentThreadSpies.remove(threadId);
                            } else {
                                this.next = spy;
                                this.threadLocalSpiesChecked = true;
                                return true;
                            }
                        }
                        this.threadLocalSpiesChecked = true;
                        return false;
                    }

                    @Override
                    public BaseSpy<?> next() {
                        return this.next;
                    }
                };
            }
        };
    }

    private static void notifyListeners(StatementMetaData statementMetaData, long elapsedTime, int bytesDown, int bytesUp, int rowsUpdated) {
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            spy.addExecutedStatement(statementMetaData, elapsedTime, bytesDown, bytesUp, rowsUpdated);
        }
    }

    private static void notifyListeners(StatementMetaData statementMetaData) {
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            spy.addReturnedRow(statementMetaData);
        }
    }

    private static void notifyListeners(SocketMetaData socketMetaData, long elapsedTime, int bytesDown, int bytesUp) {
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            spy.addSocketOperation(socketMetaData, elapsedTime, bytesDown, bytesUp);
        }
    }

    private static void notifyListeners(SocketMetaData socketMetaData, boolean sent, long timestamp, String stackTrace, byte[] traffic, int off, int len) {
        ThreadMetaData threadMetaData = ThreadMetaData.create(Thread.currentThread());
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            spy.addNetworkTraffic(socketMetaData, sent, timestamp, stackTrace, threadMetaData, traffic, off, len);
        }
    }

    private static void notifyListenersDecryptedTraffic(SocketMetaData socketMetaData, boolean sent, long timestamp, String stackTrace, byte[] traffic, int off, int len) {
        ThreadMetaData threadMetaData = ThreadMetaData.create(Thread.currentThread());
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            spy.addDecryptedNetworkTraffic(socketMetaData, sent, timestamp, stackTrace, threadMetaData, traffic, off, len);
        }
    }

    @Deprecated
    public static boolean hasSpies() {
        return Sniffy.getSniffyMode().isEnabled();
    }

    public static SpyConfiguration getEffectiveSpyConfiguration() {
        SpyConfiguration.Builder builder = SpyConfiguration.builder().captureJdbc(false).captureNetwork(false).captureNetworkTraffic(false).captureStackTraces(false);
        for (BaseSpy<?> spy : Sniffy.getEffectiveSpyList()) {
            builder = builder.or(spy.getSpyConfiguration());
        }
        return builder.build();
    }

    @Deprecated
    public static SniffyMode getSniffyMode() {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureJdbc() || effectiveSpyConfiguration.isCaptureNetwork()) {
            return effectiveSpyConfiguration.isCaptureStackTraces() ? SniffyMode.ENABLED : SniffyMode.ENABLED_NO_STACKTRACE;
        }
        return SniffyMode.DISABLED;
    }

    public static void logSocket(int connectionId, InetSocketAddress address, long elapsedTime, int bytesDown, int bytesUp) {
        Sniffy.logSocket(connectionId, address, elapsedTime, bytesDown, bytesUp, true);
    }

    public static void logSocket(int connectionId, InetSocketAddress address, long elapsedTime, int bytesDown, int bytesUp, boolean captureStackTraces) {
        SocketStats socketStats = socketStatsAccumulator.get();
        if (null != socketStats) {
            socketStats.accumulate(elapsedTime, bytesDown, bytesUp);
        } else {
            String stackTrace = captureStackTraces ? StackTraceExtractor.printStackTrace(StackTraceExtractor.getTraceTillPackage("java.net")) : null;
            SocketMetaData socketMetaData = new SocketMetaData(address, connectionId, stackTrace, Thread.currentThread());
            Sniffy.notifyListeners(socketMetaData, elapsedTime, bytesDown, bytesUp);
        }
    }

    public static void logTraffic(int connectionId, InetSocketAddress address, boolean sent, Protocol protocol, byte[] traffic, int off, int len, boolean captureStackTraces) {
        if (0 == len) {
            return;
        }
        String stackTrace = captureStackTraces ? StackTraceExtractor.printStackTrace(StackTraceExtractor.getTraceTillPackage("java.net")) : null;
        SocketMetaData socketMetaData = new SocketMetaData(protocol, address, connectionId);
        Sniffy.notifyListeners(socketMetaData, sent, System.currentTimeMillis(), stackTrace, traffic, off, len);
    }

    public static void logDecryptedTraffic(int connectionId, InetSocketAddress address, boolean sent, Protocol protocol, byte[] traffic, int off, int len, boolean captureStackTraces) {
        if (0 == len) {
            return;
        }
        String stackTrace = captureStackTraces ? StackTraceExtractor.printStackTrace(StackTraceExtractor.getTraceTillPackage("java.net")) : null;
        SocketMetaData socketMetaData = new SocketMetaData(protocol, address, connectionId);
        Sniffy.notifyListenersDecryptedTraffic(socketMetaData, sent, System.currentTimeMillis(), stackTrace, traffic, off, len);
    }

    public static void enterJdbcMethod() {
        socketStatsAccumulator.set(new SocketStats(0L, 0L, 0L));
    }

    public static void exitJdbcMethod(Method method, long elapsedTime) {
        Sniffy.exitJdbcMethod(method, elapsedTime, null);
    }

    public static void exitJdbcMethod(Method method, long elapsedTime, Method implMethod) {
        SocketStats socketStats;
        SniffyMode sniffyMode = Sniffy.getSniffyMode();
        if (sniffyMode.isEnabled() && null != (socketStats = socketStatsAccumulator.get()) && (socketStats.bytesDown.longValue() > 0L || socketStats.bytesUp.longValue() > 0L)) {
            String stackTrace = null;
            if (sniffyMode.isCaptureStackTraces()) {
                try {
                    stackTrace = StackTraceExtractor.printStackTrace(null == implMethod ? StackTraceExtractor.getTraceForProxiedMethod(method) : StackTraceExtractor.getTraceForImplementingMethod(method, implMethod));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            StatementMetaData statementMetaData = new StatementMetaData(method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()", SqlStatement.SYSTEM, stackTrace, Thread.currentThread());
            Sniffy.notifyListeners(statementMetaData, elapsedTime, socketStats.bytesDown.intValue(), socketStats.bytesUp.intValue(), 0);
        }
        socketStatsAccumulator.remove();
    }

    public static void readDatabaseRow(Method method, long elapsedTime, StatementMetaData statementMetaData) {
        Sniffy.exitJdbcMethod(method, elapsedTime);
        Sniffy.notifyListeners(statementMetaData);
    }

    public static StatementMetaData executeStatement(String sql, long elapsedTime, String stackTrace) {
        return Sniffy.executeStatement(sql, elapsedTime, stackTrace, 0);
    }

    public static StatementMetaData executeStatement(String sql, long elapsedTime, String stackTrace, int rowsUpdated) {
        Sniffer.executedStatementsGlobalCounter.incrementAndGet();
        SocketStats socketStats = socketStatsAccumulator.get();
        StatementMetaData statementMetaData = new StatementMetaData(sql, SqlUtil.guessQueryType(sql), stackTrace, Thread.currentThread());
        Sniffy.notifyListeners(statementMetaData, elapsedTime, null == socketStats ? 0 : socketStats.bytesDown.intValue(), null == socketStats ? 0 : socketStats.bytesUp.intValue(), rowsUpdated);
        socketStatsAccumulator.remove();
        return statementMetaData;
    }

    public static <T extends Spy<T>> Spy<? extends Spy<T>> spy() {
        return new Spy();
    }

    public static <T extends Spy<T>> Spy<? extends Spy<T>> spy(SpyConfiguration spyConfiguration) {
        return new Spy(spyConfiguration);
    }

    public static CurrentThreadSpy spyCurrentThread() {
        return Sniffy.spyCurrentThread(true);
    }

    public static CurrentThreadSpy spyCurrentThread(boolean captureStackTraces) {
        return new CurrentThreadSpy(captureStackTraces);
    }

    public static Spy expect(Spy.Expectation expectation) {
        return Sniffy.spy().expect(expectation);
    }

    public static Spy execute(Executable executable) {
        return Sniffy.spy().execute(executable);
    }

    public static Spy run(Runnable runnable) {
        return Sniffy.spy().run(runnable);
    }

    public static <V> Spy.SpyWithValue<V> call(Callable<V> callable) throws Exception {
        return Sniffy.spy().call(callable);
    }

    static {
        Sniffy.initialize();
        nioModuleLoaded = false;
        tlsModuleLoaded = false;
    }

    @Deprecated
    public static enum SniffyMode {
        DISABLED(false, false),
        ENABLED(true, true),
        ENABLED_NO_STACKTRACE(true, false);

        private final boolean enabled;
        private final boolean captureStackTraces;

        private SniffyMode(boolean enabled, boolean captureStackTraces) {
            this.enabled = enabled;
            this.captureStackTraces = captureStackTraces;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isCaptureStackTraces() {
            return this.captureStackTraces;
        }
    }
}

