/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.sniffy.Executable;
import io.sniffy.GroupingOptions;
import io.sniffy.LegacySpy;
import io.sniffy.Sniffy;
import io.sniffy.SniffyAssertionError;
import io.sniffy.SpyConfiguration;
import io.sniffy.ThreadMatcher;
import io.sniffy.Threads;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.socket.AddressMatcher;
import io.sniffy.socket.AddressMatchers;
import io.sniffy.socket.NetworkPacket;
import io.sniffy.socket.SocketMetaData;
import io.sniffy.socket.SocketStats;
import io.sniffy.sql.SqlStats;
import io.sniffy.sql.StatementMetaData;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.StringUtil;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class Spy<C extends Spy<C>>
extends LegacySpy<C>
implements Closeable {
    private final WeakReference<Spy> selfReference;
    private boolean closed = false;
    private StackTraceElement[] closeStackTrace;
    private List<Expectation> expectations = new ArrayList<Expectation>();

    @Override
    public Map<StatementMetaData, SqlStats> getExecutedStatements(ThreadMatcher threadMatcher, boolean removeStackTraces) {
        LinkedHashMap<StatementMetaData, SqlStats> executedStatements = new LinkedHashMap<StatementMetaData, SqlStats>();
        for (Map.Entry entry : this.executedStatements.ascendingMap().entrySet()) {
            StatementMetaData statementMetaData = (StatementMetaData)entry.getKey();
            if (removeStackTraces) {
                statementMetaData = new StatementMetaData(statementMetaData.sql, statementMetaData.query, null, statementMetaData.getThreadMetaData());
            }
            if (!threadMatcher.matches(statementMetaData.getThreadMetaData())) continue;
            SqlStats existingSocketStats = (SqlStats)executedStatements.get(statementMetaData);
            if (null == existingSocketStats) {
                executedStatements.put(statementMetaData, new SqlStats((SqlStats)entry.getValue()));
                continue;
            }
            existingSocketStats.accumulate((SqlStats)entry.getValue());
        }
        return Collections.unmodifiableMap(executedStatements);
    }

    Spy() {
        this(SpyConfiguration.builder().build());
    }

    Spy(SpyConfiguration spyConfiguration) {
        super(spyConfiguration);
        this.selfReference = Sniffy.registerSpy(this);
    }

    @Override
    public C reset() {
        this.checkOpened();
        super.reset();
        this.expectations.clear();
        return (C)((Spy)this.self());
    }

    public Map<SocketMetaData, SocketStats> getSocketOperations(ThreadMatcher threadMatcher, String address, boolean removeStackTraces) {
        return this.getSocketOperations(threadMatcher, AddressMatchers.exactAddressMatcher(address), removeStackTraces);
    }

    public Map<SocketMetaData, SocketStats> getSocketOperations(ThreadMatcher threadMatcher, boolean removeStackTraces) {
        return this.getSocketOperations(threadMatcher, AddressMatchers.anyAddressMatcher(), removeStackTraces);
    }

    public Map<SocketMetaData, SocketStats> getSocketOperations(ThreadMatcher threadMatcher, AddressMatcher addressMatcher, boolean removeStackTraces) {
        LinkedHashMap<SocketMetaData, SocketStats> socketOperations = new LinkedHashMap<SocketMetaData, SocketStats>();
        for (Map.Entry entry : this.socketOperations.ascendingMap().entrySet()) {
            SocketStats existingSocketStats;
            SocketMetaData socketMetaData = (SocketMetaData)entry.getKey();
            if (!threadMatcher.matches(socketMetaData.getThreadMetaData()) || null != addressMatcher && !addressMatcher.matches(socketMetaData.getAddress())) continue;
            if (removeStackTraces) {
                socketMetaData = new SocketMetaData(socketMetaData.getProtocol(), socketMetaData.address, socketMetaData.connectionId, null, socketMetaData.getThreadMetaData());
            }
            if (null == (existingSocketStats = (SocketStats)socketOperations.get(socketMetaData))) {
                socketOperations.put(socketMetaData, new SocketStats((SocketStats)entry.getValue()));
                continue;
            }
            existingSocketStats.accumulate((SocketStats)entry.getValue());
        }
        return Collections.unmodifiableMap(socketOperations);
    }

    public Map<SocketMetaData, List<NetworkPacket>> getNetworkTraffic() {
        return this.getNetworkTraffic((ThreadMatcher)Threads.ANY, AddressMatchers.anyAddressMatcher());
    }

    public Map<SocketMetaData, List<NetworkPacket>> getNetworkTraffic(ThreadMatcher threadMatcher, String address) {
        return this.getNetworkTraffic(threadMatcher, AddressMatchers.exactAddressMatcher(address));
    }

    public Map<SocketMetaData, List<NetworkPacket>> getNetworkTraffic(ThreadMatcher threadMatcher, String address, GroupingOptions groupingOptions) {
        return this.getNetworkTraffic(threadMatcher, AddressMatchers.exactAddressMatcher(address), groupingOptions);
    }

    public Map<SocketMetaData, List<NetworkPacket>> getNetworkTraffic(ThreadMatcher threadMatcher, AddressMatcher addressMatcher) {
        return this.getNetworkTraffic(threadMatcher, addressMatcher, GroupingOptions.builder().build());
    }

    public Map<SocketMetaData, List<NetworkPacket>> getNetworkTraffic(ThreadMatcher threadMatcher, AddressMatcher addressMatcher, GroupingOptions groupingOptions) {
        return this.filterTraffic((ConcurrentLinkedHashMap<SocketMetaData, Deque<NetworkPacket>>)this.networkTraffic, threadMatcher, addressMatcher, groupingOptions);
    }

    public Map<SocketMetaData, List<NetworkPacket>> getDecryptedNetworkTraffic(ThreadMatcher threadMatcher, AddressMatcher addressMatcher, GroupingOptions groupingOptions) {
        return this.filterTraffic((ConcurrentLinkedHashMap<SocketMetaData, Deque<NetworkPacket>>)this.decryptedNetworkTraffic, threadMatcher, addressMatcher, groupingOptions);
    }

    private Map<SocketMetaData, List<NetworkPacket>> filterTraffic(ConcurrentLinkedHashMap<SocketMetaData, Deque<NetworkPacket>> originalTraffic, ThreadMatcher threadMatcher, AddressMatcher addressMatcher, GroupingOptions groupingOptions) {
        LinkedHashMap<SocketMetaData, List<NetworkPacket>> reducedTraffic = new LinkedHashMap<SocketMetaData, List<NetworkPacket>>();
        for (Map.Entry entry : originalTraffic.ascendingMap().entrySet()) {
            SocketMetaData socketMetaData = (SocketMetaData)entry.getKey();
            Deque networkPackets = (Deque)entry.getValue();
            if (!addressMatcher.matches(socketMetaData.getAddress()) || null != socketMetaData.getThreadMetaData() && !threadMatcher.matches(socketMetaData.getThreadMetaData())) continue;
            for (NetworkPacket networkPacket : networkPackets) {
                if (!threadMatcher.matches(networkPacket.getThreadMetaData())) continue;
                SocketMetaData reducedSocketMetaData = new SocketMetaData(socketMetaData.getProtocol(), socketMetaData.getAddress(), groupingOptions.isGroupByConnection() ? socketMetaData.getConnectionId() : -1, groupingOptions.isGroupByStackTrace() ? networkPacket.getStackTrace() : null, groupingOptions.isGroupByThread() ? networkPacket.getThreadMetaData() : null);
                ArrayList<NetworkPacket> reducedNetworkPackets = (ArrayList<NetworkPacket>)reducedTraffic.get(reducedSocketMetaData);
                if (null == reducedNetworkPackets) {
                    reducedNetworkPackets = new ArrayList<NetworkPacket>();
                    reducedTraffic.put(reducedSocketMetaData, reducedNetworkPackets);
                }
                if (this.getSpyConfiguration().isCaptureStackTraces() && !groupingOptions.isGroupByStackTrace() || !groupingOptions.isGroupByThread()) {
                    byte[] bytes = networkPacket.getBytes();
                    networkPacket = new NetworkPacket(networkPacket.isSent(), networkPacket.getTimestamp(), groupingOptions.isGroupByStackTrace() ? networkPacket.getStackTrace() : null, groupingOptions.isGroupByThread() ? networkPacket.getThreadMetaData() : null, bytes, 0, bytes.length);
                }
                if (reducedNetworkPackets.isEmpty()) {
                    reducedNetworkPackets.add(networkPacket);
                    continue;
                }
                NetworkPacket lastPacket = (NetworkPacket)reducedNetworkPackets.get(reducedNetworkPackets.size() - 1);
                if (lastPacket.combine(networkPacket, SniffyConfiguration.INSTANCE.getPacketMergeThreshold())) continue;
                reducedNetworkPackets.add(networkPacket);
            }
        }
        return reducedTraffic;
    }

    @Override
    public C expect(Expectation expectation) {
        this.checkOpened();
        this.expectations.add(expectation);
        return (C)((Spy)this.self());
    }

    @Override
    public C verify(Expectation expectation) {
        this.checkOpened();
        expectation.verify(this);
        return (C)((Spy)this.self());
    }

    @Override
    public void verify() throws SniffyAssertionError {
        this.checkOpened();
        SniffyAssertionError assertionError = this.getSniffyAssertionError();
        if (null != assertionError) {
            throw assertionError;
        }
    }

    @Override
    public SniffyAssertionError getSniffyAssertionError() {
        this.checkOpened();
        SniffyAssertionError assertionError = null;
        Object currentException = null;
        for (Expectation expectation : this.expectations) {
            try {
                expectation.verify(this);
            }
            catch (SniffyAssertionError e) {
                if (null == assertionError) {
                    assertionError = e;
                    currentException = assertionError;
                    continue;
                }
                currentException.initCause((Throwable)((Object)e));
                currentException = e;
            }
        }
        return assertionError;
    }

    @Override
    public void close() {
        try {
            this.verify();
        }
        finally {
            Sniffy.removeSpyReference(this.selfReference);
            this.closed = true;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.closeStackTrace = new StackTraceElement[stackTrace.length - 1];
            System.arraycopy(stackTrace, 1, this.closeStackTrace, 0, stackTrace.length - 1);
        }
    }

    @Override
    protected void checkOpened() {
        if (this.closed) {
            throw new SpyClosedException("Spy is closed", this.closeStackTrace);
        }
    }

    @Override
    public C execute(Executable executable) throws SniffyAssertionError {
        this.checkOpened();
        try {
            executable.execute();
        }
        catch (Throwable e) {
            throw this.verifyAndAddToException(e);
        }
        this.verify();
        return (C)((Spy)this.self());
    }

    public C run(Runnable runnable) throws SniffyAssertionError {
        this.checkOpened();
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw this.verifyAndAddToException(e);
        }
        this.verify();
        return (C)((Spy)this.self());
    }

    public <V> SpyWithValue<V> call(Callable<V> callable) throws SniffyAssertionError {
        V result;
        this.checkOpened();
        try {
            result = callable.call();
        }
        catch (Throwable e) {
            throw this.verifyAndAddToException(e);
        }
        this.verify();
        return new SpyWithValue<V>(result);
    }

    private RuntimeException verifyAndAddToException(Throwable e) {
        block2: {
            try {
                this.verify();
            }
            catch (SniffyAssertionError ae) {
                if (ExceptionUtil.addSuppressed(e, (Throwable)((Object)ae))) break block2;
                ae.printStackTrace();
            }
        }
        ExceptionUtil.throwException(e);
        return new RuntimeException(e);
    }

    public static final class SpyWithValue<V>
    extends Spy<SpyWithValue<V>> {
        private final V value;

        SpyWithValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }

    public static class SpyClosedException
    extends IllegalStateException {
        private final StackTraceElement[] closeStackTrace;

        public SpyClosedException(String s, StackTraceElement[] closeStackTrace) {
            super(ExceptionUtil.generateMessage(s + StringUtil.LINE_SEPARATOR + "Close stack trace:", closeStackTrace));
            this.closeStackTrace = closeStackTrace;
        }

        public StackTraceElement[] getCloseStackTrace() {
            return null == this.closeStackTrace ? null : (StackTraceElement[])this.closeStackTrace.clone();
        }
    }

    public static interface Expectation {
        public <T extends Spy<T>> Spy<T> verify(Spy<T> var1) throws SniffyAssertionError;
    }
}

