/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy;

import io.sniffy.configuration.SniffyConfiguration;

public class SpyConfiguration {
    private final boolean captureStackTraces;
    private final boolean captureNetwork;
    private final boolean captureNetworkTraffic;
    private final boolean captureJdbc;

    private SpyConfiguration(boolean captureStackTraces, boolean captureNetwork, boolean captureNetworkTraffic, boolean captureJdbc) {
        this.captureStackTraces = captureStackTraces;
        this.captureNetwork = captureNetwork;
        this.captureNetworkTraffic = captureNetworkTraffic;
        this.captureJdbc = captureJdbc;
    }

    public boolean isCaptureStackTraces() {
        return this.captureStackTraces;
    }

    public boolean isCaptureNetwork() {
        return this.captureNetwork;
    }

    public boolean isCaptureNetworkTraffic() {
        return this.captureNetworkTraffic;
    }

    public boolean isCaptureJdbc() {
        return this.captureJdbc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean captureStackTraces = true;
        private boolean captureNetwork;
        private boolean captureNetworkTraffic;
        private boolean captureJdbc = SniffyConfiguration.INSTANCE.isMonitorJdbc();

        public Builder() {
            this.captureNetwork = SniffyConfiguration.INSTANCE.isMonitorSocket();
        }

        public Builder captureStackTraces(boolean captureStackTraces) {
            this.captureStackTraces = captureStackTraces;
            return this;
        }

        public Builder captureNetwork(boolean captureNetwork) {
            this.captureNetwork = captureNetwork;
            return this;
        }

        public Builder captureNetworkTraffic(boolean captureNetworkTraffic) {
            this.captureNetwork(captureNetworkTraffic);
            this.captureNetworkTraffic = captureNetworkTraffic;
            return this;
        }

        public Builder captureJdbc(boolean captureJdbc) {
            this.captureJdbc = captureJdbc;
            return this;
        }

        public Builder or(SpyConfiguration spyConfiguration) {
            return this.captureStackTraces(this.captureStackTraces || spyConfiguration.captureStackTraces).captureNetwork(this.captureNetwork || spyConfiguration.captureNetwork).captureNetworkTraffic(this.captureNetworkTraffic || spyConfiguration.captureNetworkTraffic).captureJdbc(this.captureJdbc || spyConfiguration.captureJdbc);
        }

        public SpyConfiguration build() {
            return new SpyConfiguration(this.captureStackTraces, this.captureNetwork, this.captureNetworkTraffic, this.captureJdbc);
        }
    }
}

