/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy;

import io.sniffy.ThreadMatcher;
import io.sniffy.ThreadMetaData;

public enum Threads implements ThreadMatcher
{
    ANY,
    CURRENT,
    OTHERS;


    @Override
    public boolean matches(ThreadMetaData threadMetaData) {
        switch (this) {
            case ANY: {
                return true;
            }
            case CURRENT: {
                return Thread.currentThread().getId() == threadMetaData.getThreadId();
            }
            case OTHERS: {
                return Thread.currentThread().getId() != threadMetaData.getThreadId();
            }
        }
        return false;
    }

    @Override
    public void describe(StringBuilder appendable) {
        switch (this) {
            case CURRENT: {
                appendable.append(" current thread");
                break;
            }
            case OTHERS: {
                appendable.append(" other threads");
                break;
            }
        }
    }
}

