/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.configuration;

import io.sniffy.log.PolyglogLevel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public enum SniffyConfiguration {
    INSTANCE;

    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private volatile PolyglogLevel logLevel;
    private volatile boolean monitorJdbc;
    private volatile boolean monitorSocket;
    private volatile boolean monitorNio;
    private volatile boolean decryptTls;
    @Deprecated
    private volatile boolean captureTraffic;
    private volatile int topSqlCapacity;
    private volatile int packetMergeThreshold;
    private volatile Boolean filterEnabled;
    private volatile String excludePattern;
    private volatile Boolean injectHtmlEnabled;
    private volatile String injectHtmlExcludePattern;
    private volatile Boolean jdbcCaptureEnabled;
    private volatile Boolean jdbcFaultInjectionEnabled;
    private volatile Boolean socketCaptureEnabled;
    private volatile Boolean socketFaultInjectionEnabled;

    private SniffyConfiguration() {
        this.loadSniffyConfiguration();
    }

    void loadSniffyConfiguration() {
        String logLevelProperty = this.getProperty("io.sniffy.logLevel", "IO_SNIFFY_LOG_LEVEL", "info");
        PolyglogLevel polyglogLevel = PolyglogLevel.parse(logLevelProperty);
        this.logLevel = null == polyglogLevel ? PolyglogLevel.INFO : polyglogLevel;
        this.monitorJdbc = Boolean.parseBoolean(this.getProperty("io.sniffy.monitorJdbc", "IO_SNIFFY_MONITOR_JDBC", "true"));
        this.monitorSocket = Boolean.parseBoolean(this.getProperty("io.sniffy.monitorSocket", "IO_SNIFFY_MONITOR_SOCKET", "false"));
        this.monitorNio = Boolean.parseBoolean(this.getProperty("io.sniffy.monitorNio", "IO_SNIFFY_MONITOR_NIO", "false"));
        this.decryptTls = Boolean.parseBoolean(this.getProperty("io.sniffy.decryptTls", "IO_SNIFFY_DECRYPT_TLS", "false"));
        try {
            this.topSqlCapacity = Integer.parseInt(this.getProperty("io.sniffy.topSqlCapacity", "IO_SNIFFY_TOP_SQL_CAPACITY", "1024"));
        }
        catch (NumberFormatException e) {
            this.topSqlCapacity = 0;
        }
        try {
            this.packetMergeThreshold = Integer.parseInt(this.getProperty("io.sniffy.packetMergeThreshold", "IO_SNIFFY_PACKET_MERGE_THRESHOLD", "500"));
        }
        catch (NumberFormatException e) {
            this.packetMergeThreshold = 0;
        }
        String filterEnabled = this.getProperty("io.sniffy.filterEnabled", "IO_SNIFFY_FILTER_ENABLED");
        this.filterEnabled = null == filterEnabled ? null : Boolean.valueOf(Boolean.parseBoolean(filterEnabled));
        this.excludePattern = this.getProperty("io.sniffy.excludePattern", "IO_SNIFFY_EXCLUDE_PATTERN", null);
        String injectHtmlEnabled = this.getProperty("io.sniffy.injectHtml", "IO_SNIFFY_INJECT_HTML");
        this.injectHtmlEnabled = null == injectHtmlEnabled ? null : Boolean.valueOf(Boolean.parseBoolean(injectHtmlEnabled));
        this.injectHtmlExcludePattern = this.getProperty("io.sniffy.injectHtmlExcludePattern", "IO_SNIFFY_INJECT_HTML_EXCLUDE_PATTERN", null);
        String jdbcCaptureEnabled = this.getProperty("io.sniffy.jdbcCaptureEnabled", "IO_SNIFFY_JDBC_CAPTURE_ENABLED");
        this.jdbcCaptureEnabled = null == jdbcCaptureEnabled || Boolean.parseBoolean(jdbcCaptureEnabled);
        String jdbcFaultInjectionEnabled = this.getProperty("io.sniffy.jdbcFaultInjectionEnabled", "IO_SNIFFY_JDBC_FAULT_INJECTION_ENABLED");
        this.jdbcFaultInjectionEnabled = null == jdbcFaultInjectionEnabled || Boolean.parseBoolean(jdbcFaultInjectionEnabled);
        String socketCaptureEnabled = this.getProperty("io.sniffy.socketCaptureEnabled", "IO_SNIFFY_SOCKET_CAPTURE_ENABLED");
        this.socketCaptureEnabled = null == socketCaptureEnabled || Boolean.parseBoolean(socketCaptureEnabled);
        String socketFaultInjectionEnabled = this.getProperty("io.sniffy.socketFaultInjectionEnabled", "IO_SNIFFY_SOCKET_FAULT_INJECTION_ENABLED");
        this.socketFaultInjectionEnabled = null == socketFaultInjectionEnabled || Boolean.parseBoolean(socketFaultInjectionEnabled);
    }

    private String getProperty(String systemPropertyName, String environmentVariableName, String defaultValue) {
        return this.valueOrDefault(this.getProperty(systemPropertyName, environmentVariableName), defaultValue);
    }

    private String valueOrDefault(String value, String defaultValue) {
        return null == value ? defaultValue : value;
    }

    private String getProperty(String systemPropertyName, String environmentVariableName) {
        String property;
        String value = null;
        String env = System.getenv(environmentVariableName);
        if (null != env) {
            value = env;
        }
        if (null != (property = System.getProperty(systemPropertyName))) {
            value = property;
        }
        return value;
    }

    public PolyglogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(PolyglogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isMonitorJdbc() {
        return this.monitorJdbc;
    }

    public void setMonitorJdbc(boolean monitorJdbc) {
        this.monitorJdbc = monitorJdbc;
    }

    public boolean isMonitorSocket() {
        return this.monitorSocket;
    }

    public void setMonitorSocket(boolean monitorSocket) {
        boolean oldValue = this.monitorSocket;
        this.monitorSocket = monitorSocket;
        this.pcs.firePropertyChange("monitorSocket", oldValue, monitorSocket);
    }

    public boolean isMonitorNio() {
        return this.monitorNio;
    }

    public void setMonitorNio(boolean monitorNio) {
        boolean oldValue = this.monitorNio;
        this.monitorNio = monitorNio;
        this.pcs.firePropertyChange("monitorNio", oldValue, monitorNio);
    }

    public boolean isDecryptTls() {
        return this.decryptTls;
    }

    public void setDecryptTls(boolean decryptTls) {
        boolean oldValue = this.decryptTls;
        this.decryptTls = decryptTls;
        this.pcs.firePropertyChange("decryptTls", oldValue, decryptTls);
    }

    @Deprecated
    public boolean isCaptureTraffic() {
        return this.captureTraffic;
    }

    @Deprecated
    public void setCaptureTraffic(boolean captureTraffic) {
        boolean oldValue = this.captureTraffic;
        this.captureTraffic = captureTraffic;
        this.pcs.firePropertyChange("captureTraffic", oldValue, captureTraffic);
    }

    public void addMonitorSocketListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener("monitorSocket", listener);
    }

    public void removeMonitorSocketListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener("monitorSocket", listener);
    }

    public void addMonitorNioListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener("monitorNio", listener);
    }

    public void removeMonitorNioListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener("monitorNio", listener);
    }

    public void addDecryptTlsListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener("decryptTls", listener);
    }

    public void removeDecryptTlsListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener("decryptTls", listener);
    }

    public int getTopSqlCapacity() {
        return this.topSqlCapacity;
    }

    public void setTopSqlCapacity(int topSqlCapacity) {
        int oldValue = this.topSqlCapacity;
        this.topSqlCapacity = topSqlCapacity;
        this.pcs.firePropertyChange("topSqlCapacity", oldValue, topSqlCapacity);
    }

    public int getPacketMergeThreshold() {
        return this.packetMergeThreshold;
    }

    public void setPacketMergeThreshold(int packetMergeThreshold) {
        int oldValue = this.packetMergeThreshold;
        this.packetMergeThreshold = packetMergeThreshold;
        this.pcs.firePropertyChange("packetMergeThreshold", oldValue, packetMergeThreshold);
    }

    public void addTopSqlCapacityListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener("topSqlCapacity", listener);
    }

    public void removeTopSqlCapacityListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener("topSqlCapacity", listener);
    }

    public void addPacketMergeThresholdListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener("packetMergeThreshold", listener);
    }

    public void removePacketMergeThresholdListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener("packetMergeThreshold", listener);
    }

    public Boolean getFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(Boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public Boolean getInjectHtmlEnabled() {
        return this.injectHtmlEnabled;
    }

    public void setInjectHtmlEnabled(Boolean injectHtmlEnabled) {
        this.injectHtmlEnabled = injectHtmlEnabled;
    }

    public String getInjectHtmlExcludePattern() {
        return this.injectHtmlExcludePattern;
    }

    public void setInjectHtmlExcludePattern(String injectHtmlExcludePattern) {
        this.injectHtmlExcludePattern = injectHtmlExcludePattern;
    }

    public Boolean getJdbcCaptureEnabled() {
        return this.jdbcCaptureEnabled;
    }

    public void setJdbcCaptureEnabled(Boolean jdbcCaptureEnabled) {
        this.jdbcCaptureEnabled = jdbcCaptureEnabled;
    }

    public Boolean getJdbcFaultInjectionEnabled() {
        return this.jdbcFaultInjectionEnabled;
    }

    public void setJdbcFaultInjectionEnabled(Boolean jdbcFaultInjectionEnabled) {
        this.jdbcFaultInjectionEnabled = jdbcFaultInjectionEnabled;
    }

    public Boolean getSocketCaptureEnabled() {
        return this.socketCaptureEnabled;
    }

    public void setSocketCaptureEnabled(Boolean socketCaptureEnabled) {
        this.socketCaptureEnabled = socketCaptureEnabled;
    }

    public Boolean getSocketFaultInjectionEnabled() {
        return this.socketFaultInjectionEnabled;
    }

    public void setSocketFaultInjectionEnabled(Boolean socketFaultInjectionEnabled) {
        this.socketFaultInjectionEnabled = socketFaultInjectionEnabled;
    }
}

