/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.log;

import io.sniffy.log.AbstractPolyglogImpl;
import io.sniffy.log.PolyglogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PolyglogSystemOutImpl
extends AbstractPolyglogImpl {
    private final String name;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        }
    };

    public PolyglogSystemOutImpl(String name) {
        this.name = name;
    }

    public PolyglogSystemOutImpl(Class<?> clazz) {
        this(null == clazz ? null : clazz.getSimpleName());
    }

    @Override
    public void log(PolyglogLevel level, String message) {
        if (this.isLevelEnabled(level)) {
            System.out.println(DATE_FORMAT_THREAD_LOCAL.get().format(new Date()) + " [" + level.name() + "] [" + Thread.currentThread().getName() + "] " + (null == this.name ? "" : "[" + this.name + "] ") + message);
        }
    }

    @Override
    public void error(String message, Exception e) {
        this.log(PolyglogLevel.ERROR, message);
        this.error(e);
    }

    @Override
    public void error(Throwable e) {
        if (null != e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.log(PolyglogLevel.ERROR, sw.toString());
        }
    }
}

