/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.registry;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import io.sniffy.registry.ConnectionsRegistryStorage;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ConnectionsRegistry implements Runnable
{
    INSTANCE;

    private final Map<Map.Entry<String, Integer>, Integer> discoveredAddresses = new ConcurrentHashMap<Map.Entry<String, Integer>, Integer>();
    private final Map<Map.Entry<String, String>, Integer> discoveredDataSources = new ConcurrentHashMap<Map.Entry<String, String>, Integer>();
    protected final Map<Map.Entry<String, Integer>, Collection<Reference<SniffyNetworkConnection>>> sniffySocketImpls = new ConcurrentHashMap<Map.Entry<String, Integer>, Collection<Reference<SniffyNetworkConnection>>>();
    private volatile boolean persistRegistry = false;
    private final ReferenceQueue<SniffyNetworkConnection> sniffySocketReferenceQueue = new ReferenceQueue();
    private final Thread housekeepingThread = new Thread((Runnable)this, "SniffyConnectionRegistryHouseKeeper");
    private final ThreadLocal<Map<Map.Entry<String, Integer>, Integer>> threadLocalDiscoveredAddresses = new ThreadLocal<Map<Map.Entry<String, Integer>, Integer>>(){

        @Override
        protected Map<Map.Entry<String, Integer>, Integer> initialValue() {
            return new ConcurrentHashMap<Map.Entry<String, Integer>, Integer>();
        }
    };
    private final ThreadLocal<Map<Map.Entry<String, String>, Integer>> threadLocalDiscoveredDataSources = new ThreadLocal<Map<Map.Entry<String, String>, Integer>>(){

        @Override
        protected Map<Map.Entry<String, String>, Integer> initialValue() {
            return new ConcurrentHashMap<Map.Entry<String, String>, Integer>();
        }
    };
    private volatile boolean threadLocal = false;

    public void setThreadLocalDiscoveredAddresses(Map<Map.Entry<String, Integer>, Integer> discoveredAddresses) {
        this.threadLocalDiscoveredAddresses.set(discoveredAddresses);
    }

    public void setThreadLocalDiscoveredDataSources(Map<Map.Entry<String, String>, Integer> discoveredDataSources) {
        this.threadLocalDiscoveredDataSources.set(discoveredDataSources);
    }

    private ConnectionsRegistry() {
        try {
            ConnectionsRegistryStorage.INSTANCE.loadConnectionsRegistry(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.housekeepingThread.setDaemon(true);
        this.housekeepingThread.start();
    }

    public Integer resolveDataSourceStatus(String url, String userName) {
        Map<Map.Entry<String, String>, Integer> discoveredDataSources = this.getDiscoveredDataSources();
        for (Map.Entry<Map.Entry<String, String>, Integer> entry : discoveredDataSources.entrySet()) {
            if (null != url && !url.equals(entry.getKey().getKey()) || null != userName && !userName.equals(entry.getKey().getValue()) || 0 == entry.getValue()) continue;
            return entry.getValue();
        }
        this.setDataSourceStatus(url, userName, 0);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolveSocketAddressStatus(InetSocketAddress inetSocketAddress, SniffyNetworkConnection sniffyNetworkConnection) {
        if (null == inetSocketAddress || null == inetSocketAddress.getAddress()) {
            return 0;
        }
        Map<Map.Entry<String, Integer>, Integer> discoveredAddresses = this.getDiscoveredAddresses();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (null != sniffyNetworkConnection && !this.threadLocal) {
            Map<Map.Entry<String, Integer>, Collection<Reference<SniffyNetworkConnection>>> map;
            AbstractMap.SimpleEntry<String, Integer> hostNamePortPair = new AbstractMap.SimpleEntry<String, Integer>(inetAddress.getHostName(), inetSocketAddress.getPort());
            Collection<Reference<SniffyNetworkConnection>> sniffySockets = this.sniffySocketImpls.get(hostNamePortPair);
            if (null == sniffySockets) {
                map = this.sniffySocketImpls;
                synchronized (map) {
                    sniffySockets = this.sniffySocketImpls.get(hostNamePortPair);
                    if (null == sniffySockets) {
                        sniffySockets = Collections.newSetFromMap(new ConcurrentHashMap());
                        this.sniffySocketImpls.put(hostNamePortPair, sniffySockets);
                    }
                }
            }
            sniffySockets.add(new WeakReference<SniffyNetworkConnection>(sniffyNetworkConnection, this.sniffySocketReferenceQueue));
            AbstractMap.SimpleEntry<String, Integer> hostAddressPortPair = new AbstractMap.SimpleEntry<String, Integer>(inetAddress.getHostAddress(), inetSocketAddress.getPort());
            sniffySockets = this.sniffySocketImpls.get(hostAddressPortPair);
            if (null == sniffySockets) {
                map = this.sniffySocketImpls;
                synchronized (map) {
                    sniffySockets = this.sniffySocketImpls.get(hostAddressPortPair);
                    if (null == sniffySockets) {
                        sniffySockets = Collections.newSetFromMap(new ConcurrentHashMap());
                        this.sniffySocketImpls.put(hostAddressPortPair, sniffySockets);
                    }
                }
            }
            sniffySockets.add(new WeakReference<SniffyNetworkConnection>(sniffyNetworkConnection, this.sniffySocketReferenceQueue));
        }
        for (Map.Entry<Map.Entry<String, Integer>, Integer> entry : discoveredAddresses.entrySet()) {
            String hostName = entry.getKey().getKey();
            Integer port = entry.getKey().getValue();
            if (null != hostName && !hostName.equals(inetAddress.getHostName()) && !hostName.equals(inetAddress.getHostAddress()) || null != port && port.intValue() != inetSocketAddress.getPort() || 0 == entry.getValue()) continue;
            return entry.getValue();
        }
        this.setSocketAddressStatus(inetSocketAddress.getHostName(), inetSocketAddress.getPort(), 0);
        return 0;
    }

    public Map<Map.Entry<String, Integer>, Integer> getDiscoveredAddresses() {
        return Collections.unmodifiableMap(this.getDiscoveredAddressesImpl());
    }

    private Map<Map.Entry<String, Integer>, Integer> getDiscoveredAddressesImpl() {
        return this.threadLocal ? this.threadLocalDiscoveredAddresses.get() : this.discoveredAddresses;
    }

    public void setSocketAddressStatus(String hostName, Integer port, Integer connectionStatus) {
        Collection<Reference<SniffyNetworkConnection>> sniffySockets;
        Map<Map.Entry<String, Integer>, Integer> discoveredAddresses = this.getDiscoveredAddressesImpl();
        discoveredAddresses.put(new AbstractMap.SimpleEntry<String, Integer>(hostName, port), connectionStatus);
        if (this.persistRegistry) {
            try {
                ConnectionsRegistryStorage.INSTANCE.storeConnectionsRegistry(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != (sniffySockets = this.sniffySocketImpls.get(new AbstractMap.SimpleEntry<String, Integer>(hostName, port)))) {
            for (Reference<SniffyNetworkConnection> sniffySocketWeakReference : sniffySockets) {
                SniffyNetworkConnection sniffyNetworkConnection = sniffySocketWeakReference.get();
                if (null == sniffyNetworkConnection) continue;
                sniffyNetworkConnection.setConnectionStatus(connectionStatus);
            }
        }
    }

    public Map<Map.Entry<String, String>, Integer> getDiscoveredDataSources() {
        return this.threadLocal ? this.threadLocalDiscoveredDataSources.get() : this.discoveredDataSources;
    }

    public void setDataSourceStatus(String url, String userName, Integer status) {
        Map<Map.Entry<String, String>, Integer> discoveredDataSources = this.getDiscoveredDataSources();
        discoveredDataSources.put(new AbstractMap.SimpleEntry<String, String>(url, userName), status);
        if (this.persistRegistry) {
            try {
                ConnectionsRegistryStorage.INSTANCE.storeConnectionsRegistry(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isPersistRegistry() {
        return this.persistRegistry;
    }

    public void setPersistRegistry(boolean persistRegistry) {
        this.persistRegistry = persistRegistry;
    }

    public boolean isThreadLocal() {
        return this.threadLocal;
    }

    public void setThreadLocal(boolean threadLocal) {
        this.threadLocal = threadLocal;
    }

    public void clear() {
        this.discoveredAddresses.clear();
        this.discoveredDataSources.clear();
        this.persistRegistry = false;
        this.sniffySocketImpls.clear();
    }

    public void readFrom(Reader reader) throws IOException {
        Integer connectionStatus;
        int i;
        JsonObject json = Json.parse((Reader)reader).asObject();
        if (null != json.get("sockets")) {
            JsonArray sockets = json.get("sockets").asArray();
            for (i = 0; i < sockets.size(); ++i) {
                JsonObject socket = sockets.get(i).asObject();
                String hostName = socket.get("host").asString();
                int port = Integer.parseInt(socket.get("port").asString());
                connectionStatus = socket.get("status").asInt();
                this.discoveredAddresses.put(new AbstractMap.SimpleEntry<String, Integer>(hostName, port), connectionStatus);
            }
        }
        if (null != json.get("dataSources")) {
            JsonArray dataSources = json.get("dataSources").asArray();
            for (i = 0; i < dataSources.size(); ++i) {
                JsonObject dataSource = dataSources.get(i).asObject();
                String url = dataSource.get("url").asString();
                String userName = dataSource.get("userName").asString();
                connectionStatus = dataSource.get("status").asInt();
                this.discoveredDataSources.put(new AbstractMap.SimpleEntry<String, String>(url, userName), connectionStatus);
            }
        }
    }

    public void writeTo(OutputStream outputStream, String charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        this.writeTo(writer);
        writer.flush();
    }

    public void writeTo(Writer writer) throws IOException {
        Map.Entry<Map.Entry<String, Object>, Integer> entry;
        Iterator<Map.Entry<Map.Entry<String, Object>, Integer>> iterator;
        Map<Map.Entry<String, Integer>, Integer> discoveredAddresses = this.getDiscoveredAddresses();
        Map<Map.Entry<String, String>, Integer> discoveredDataSources = this.getDiscoveredDataSources();
        writer.write("{");
        writer.write("\"persistent\":");
        writer.write(Boolean.toString(this.persistRegistry));
        if (!discoveredAddresses.isEmpty()) {
            writer.write(",\"sockets\":[");
            iterator = discoveredAddresses.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String hostName = entry.getKey().getKey();
                Integer port = (Integer)entry.getKey().getValue();
                writer.write(123);
                if (null != hostName) {
                    writer.write("\"host\":");
                    writer.write(StringUtil.escapeJsonString(hostName));
                }
                if (null != port) {
                    if (null != hostName) {
                        writer.write(44);
                    }
                    writer.write("\"port\":\"");
                    writer.write(port.toString());
                    writer.write("\"");
                }
                writer.write(44);
                writer.write("\"status\":");
                writer.write(entry.getValue().toString());
                writer.write(125);
                if (!iterator.hasNext()) continue;
                writer.write(44);
            }
            writer.write(93);
            writer.flush();
        }
        if (!discoveredDataSources.isEmpty()) {
            writer.write(",\"dataSources\":[");
            iterator = discoveredDataSources.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String url = entry.getKey().getKey();
                String userName = (String)entry.getKey().getValue();
                writer.write(123);
                if (null != url) {
                    writer.write("\"url\":");
                    writer.write(StringUtil.escapeJsonString(url));
                }
                if (null != userName) {
                    if (null != url) {
                        writer.write(44);
                    }
                    writer.write("\"userName\":");
                    writer.write(StringUtil.escapeJsonString(userName));
                }
                writer.write(44);
                writer.write("\"status\":");
                writer.write(entry.getValue().toString());
                writer.write(125);
                if (!iterator.hasNext()) continue;
                writer.write(44);
            }
            writer.write(93);
            writer.flush();
        }
        writer.write("}");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Reference<SniffyNetworkConnection> reference = this.sniffySocketReferenceQueue.remove();
                SniffyNetworkConnection sniffyNetworkConnection = reference.get();
                if (null == sniffyNetworkConnection) continue;
                InetSocketAddress inetSocketAddress = sniffyNetworkConnection.getInetSocketAddress();
                Collection<Reference<SniffyNetworkConnection>> sniffySockets = this.sniffySocketImpls.get(new AbstractMap.SimpleEntry<String, Integer>(inetSocketAddress.getAddress().getHostName(), inetSocketAddress.getPort()));
                if (null != sniffySockets) {
                    sniffySockets.remove(reference);
                }
                if (null == (sniffySockets = this.sniffySocketImpls.get(new AbstractMap.SimpleEntry<String, Integer>(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort())))) continue;
                sniffySockets.remove(reference);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

