/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.registry;

import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.util.IOUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public enum ConnectionsRegistryStorage {
    INSTANCE;

    private File file = new File(IOUtil.getApplicationSniffyFolder(), "connectionsRegistry.json");

    public void loadConnectionsRegistry(ConnectionsRegistry connectionsRegistry) throws IOException {
        FileReader reader = null;
        try {
            if (this.file.exists()) {
                reader = new FileReader(this.file);
                connectionsRegistry.readFrom(reader);
            }
        }
        finally {
            IOUtil.closeSilently(reader);
            this.file.delete();
        }
    }

    public void storeConnectionsRegistry(ConnectionsRegistry connectionsRegistry) throws IOException {
        if (ConnectionsRegistry.INSTANCE.isThreadLocal()) {
            return;
        }
        FileWriter writer = null;
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            writer = new FileWriter(this.file);
            connectionsRegistry.writeTo(writer);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilently(writer);
            throw throwable;
        }
        IOUtil.closeSilently(writer);
    }
}

