/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.socket.AddressMatcher;
import io.sniffy.util.SocketUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;

public class AddressMatchers {
    public static AddressMatcher exactAddressMatcher(String address) {
        Map.Entry<String, Integer> hostAndPort = SocketUtil.parseSocketAddress(address);
        String hostName = hostAndPort.getKey();
        Integer port = hostAndPort.getValue();
        return new ExactAddressMatcher(hostName, port);
    }

    public static AddressMatcher anyAddressMatcher() {
        return new AnyAddressMatcher();
    }

    private static final class AnyAddressMatcher
    implements AddressMatcher {
        private AnyAddressMatcher() {
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            return true;
        }

        @Override
        public void describe(StringBuilder appendable) {
        }
    }

    private static final class ExactAddressMatcher
    implements AddressMatcher {
        private final String hostName;
        private final Integer port;

        public ExactAddressMatcher(String hostName, Integer port) {
            this.hostName = hostName;
            this.port = port;
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            return !(null != this.hostName && (null == inetAddress || !this.hostName.equalsIgnoreCase(inetAddress.getHostName()) && !this.hostName.equalsIgnoreCase(inetAddress.getHostAddress())) && (null != inetAddress || !this.hostName.equalsIgnoreCase(inetSocketAddress.getHostName()) && !this.hostName.equalsIgnoreCase(inetSocketAddress.getHostString())) || null != this.port && this.port.intValue() != inetSocketAddress.getPort());
        }

        @Override
        public void describe(StringBuilder appendable) {
            if (null != this.hostName) {
                appendable.append(this.hostName);
            }
            if (null != this.port) {
                appendable.append(":").append(this.port);
            }
        }
    }
}

