/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.Sniffy;
import io.sniffy.SpyConfiguration;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.socket.CompatSniffySocketImplAdapter;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.Sleep;
import io.sniffy.socket.SnifferInputStream;
import io.sniffy.socket.SnifferOutputStream;
import io.sniffy.socket.SniffyNetworkConnection;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

class CompatSnifferSocketImpl
extends CompatSniffySocketImplAdapter
implements SniffyNetworkConnection {
    private static final Polyglog LOG = PolyglogFactory.log(CompatSnifferSocketImpl.class);
    private final Sleep sleep;
    private InetSocketAddress address;
    private final int id = Sniffy.CONNECTION_ID_SEQUENCE.getAndIncrement();
    private volatile Integer connectionStatus;
    private volatile int potentiallyBufferedInputBytes = 0;
    private volatile int potentiallyBufferedOutputBytes = 0;
    private volatile long lastReadThreadId;
    private volatile long lastWriteThreadId;

    protected CompatSnifferSocketImpl(SocketImpl delegate, Sleep sleep) {
        super(delegate);
        this.sleep = sleep;
    }

    protected CompatSnifferSocketImpl(SocketImpl delegate) {
        this(delegate, new Sleep());
    }

    @Override
    public void setConnectionStatus(Integer connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    @Override
    @Deprecated
    public void logSocket(long millis) {
        this.logSocket(millis, 0, 0);
    }

    @Override
    @Deprecated
    public void logSocket(long millis, int bytesDown, int bytesUp) {
        Sniffy.SniffyMode sniffyMode;
        if (!SniffyConfiguration.INSTANCE.getSocketCaptureEnabled().booleanValue()) {
            return;
        }
        if (null != this.address && (millis > 0L || bytesDown > 0 || bytesUp > 0) && (sniffyMode = Sniffy.getSniffyMode()).isEnabled()) {
            Sniffy.logSocket(this.id, this.address, millis, bytesDown, bytesUp, sniffyMode.isCaptureStackTraces());
        }
    }

    @Override
    public void logTraffic(boolean sent, Protocol protocol, byte[] traffic, int off, int len) {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
            LOG.trace("CompatSnifferSocketImpl.logTraffic() called; sent = " + sent + "; len = " + len + "; connectionId = " + this.id);
            Sniffy.logTraffic(this.id, this.getInetSocketAddress(), sent, protocol, traffic, off, len, effectiveSpyConfiguration.isCaptureStackTraces());
        }
    }

    @Override
    public void checkConnectionAllowed() throws ConnectException {
        this.checkConnectionAllowed(0);
    }

    @Override
    public void checkConnectionAllowed(int numberOfSleepCycles) throws ConnectException {
        this.checkConnectionAllowed(this.address, numberOfSleepCycles);
    }

    @Override
    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress) throws ConnectException {
        this.checkConnectionAllowed(inetSocketAddress, 1);
    }

    @Override
    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress, int numberOfSleepCycles) throws ConnectException {
        if (!SniffyConfiguration.INSTANCE.getSocketFaultInjectionEnabled().booleanValue()) {
            return;
        }
        if (null != inetSocketAddress) {
            if (null == this.connectionStatus || ConnectionsRegistry.INSTANCE.isThreadLocal()) {
                this.connectionStatus = ConnectionsRegistry.INSTANCE.resolveSocketAddressStatus(inetSocketAddress, this);
            }
            if (this.connectionStatus < 0) {
                if (numberOfSleepCycles > 0 && -1 != this.connectionStatus) {
                    try {
                        this.sleepImpl(-1 * this.connectionStatus * numberOfSleepCycles);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw new ConnectException(String.format("Connection to %s refused by Sniffy", inetSocketAddress));
            }
            if (numberOfSleepCycles > 0 && this.connectionStatus > 0) {
                try {
                    this.sleepImpl(this.connectionStatus * numberOfSleepCycles);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void sleepImpl(int millis) throws InterruptedException {
        this.sleep.doSleep(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendUrgentData(int data) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.checkConnectionAllowed(1);
            super.sendUrgentData(data);
            this.logSocket(System.currentTimeMillis() - start, 0, 1);
        }
        catch (Throwable throwable) {
            this.logSocket(System.currentTimeMillis() - start, 0, 1);
            this.logTraffic(true, Protocol.TCP, new byte[]{(byte)data}, 0, 1);
            throw throwable;
        }
        this.logTraffic(true, Protocol.TCP, new byte[]{(byte)data}, 0, 1);
    }

    @Override
    protected void shutdownInput() throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.shutdownInput();
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.shutdownOutput();
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileDescriptor getFileDescriptor() {
        long start = System.currentTimeMillis();
        try {
            FileDescriptor fileDescriptor = super.getFileDescriptor();
            return fileDescriptor;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InetAddress getInetAddress() {
        long start = System.currentTimeMillis();
        try {
            InetAddress inetAddress = super.getInetAddress();
            return inetAddress;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getPort() {
        long start = System.currentTimeMillis();
        try {
            int n = super.getPort();
            return n;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean supportsUrgentData() {
        long start = System.currentTimeMillis();
        try {
            boolean bl = super.supportsUrgentData();
            return bl;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocalPort() {
        long start = System.currentTimeMillis();
        try {
            int n = super.getLocalPort();
            return n;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        long start = System.currentTimeMillis();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        long start = System.currentTimeMillis();
        try {
            super.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(boolean stream) throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.create(stream);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String host, int port) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.address = new InetSocketAddress(host, port);
            this.checkConnectionAllowed(this.address);
            super.connect(host, port);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.address = new InetSocketAddress(address, port);
            this.checkConnectionAllowed(this.address);
            super.connect(address, port);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        long start = System.currentTimeMillis();
        try {
            if (address instanceof InetSocketAddress) {
                this.address = (InetSocketAddress)address;
                this.checkConnectionAllowed(this.address);
            }
            super.connect(address, timeout);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.bind(host, port);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void listen(int backlog) throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.listen(backlog);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(SocketImpl s) throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.accept(s);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream getInputStream() throws IOException {
        long start = System.currentTimeMillis();
        this.checkConnectionAllowed();
        try {
            SnifferInputStream snifferInputStream = new SnifferInputStream(this, super.getInputStream());
            return snifferInputStream;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutputStream getOutputStream() throws IOException {
        long start = System.currentTimeMillis();
        this.checkConnectionAllowed();
        try {
            SnifferOutputStream snifferOutputStream = new SnifferOutputStream(this, super.getOutputStream());
            return snifferOutputStream;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int available() throws IOException {
        long start = System.currentTimeMillis();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    protected void close() throws IOException {
        this.checkConnectionAllowed(1);
        long start = System.currentTimeMillis();
        try {
            super.close();
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(int optID, Object value) throws SocketException {
        long start = System.currentTimeMillis();
        try {
            super.setOption(optID, value);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOption(int optID) throws SocketException {
        long start = System.currentTimeMillis();
        try {
            Object object = super.getOption(optID);
            return object;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    public int getPotentiallyBufferedInputBytes() {
        return this.potentiallyBufferedInputBytes;
    }

    @Override
    public void setPotentiallyBufferedInputBytes(int potentiallyBufferedInputBytes) {
        this.potentiallyBufferedInputBytes = potentiallyBufferedInputBytes;
    }

    @Override
    public int getPotentiallyBufferedOutputBytes() {
        return this.potentiallyBufferedOutputBytes;
    }

    @Override
    public void setPotentiallyBufferedOutputBytes(int potentiallyBufferedOutputBytes) {
        this.potentiallyBufferedOutputBytes = potentiallyBufferedOutputBytes;
    }

    @Override
    public long getLastReadThreadId() {
        return this.lastReadThreadId;
    }

    @Override
    public void setLastReadThreadId(long lastReadThreadId) {
        this.lastReadThreadId = lastReadThreadId;
    }

    @Override
    public long getLastWriteThreadId() {
        return this.lastWriteThreadId;
    }

    @Override
    public void setLastWriteThreadId(long lastWriteThreadId) {
        this.lastWriteThreadId = lastWriteThreadId;
    }
}

