/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.ReflectionCopier;
import io.sniffy.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

class CompatSniffySocketImplAdapter
extends SocketImpl {
    private static final ReflectionCopier<SocketImpl> socketChannelFieldsCopier = new ReflectionCopier<SocketImpl>(SocketImpl.class);
    protected final SocketImpl delegate;

    protected CompatSniffySocketImplAdapter(SocketImpl delegate) {
        this.delegate = delegate;
    }

    private void copyToDelegate() {
        socketChannelFieldsCopier.copy(this, this.delegate);
    }

    private void copyFromDelegate() {
        socketChannelFieldsCopier.copy(this.delegate, this);
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "sendUrgentData", Integer.TYPE, data, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "shutdownInput", Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "shutdownOutput", Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        this.copyToDelegate();
        try {
            FileDescriptor fileDescriptor = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getFileDescriptor", FileDescriptor.class);
            return fileDescriptor;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected InetAddress getInetAddress() {
        this.copyToDelegate();
        try {
            InetAddress inetAddress = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getInetAddress", InetAddress.class);
            return inetAddress;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected int getPort() {
        this.copyToDelegate();
        try {
            int n = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getPort", Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        this.copyToDelegate();
        try {
            boolean bl = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "supportsUrgentData", Boolean.TYPE);
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected int getLocalPort() {
        this.copyToDelegate();
        try {
            int n = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getLocalPort", Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    public String toString() {
        this.copyToDelegate();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "setPerformancePreferences", Integer.TYPE, connectionTime, Integer.TYPE, latency, Integer.TYPE, bandwidth, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void create(boolean stream) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "create", Boolean.TYPE, stream, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "connect", String.class, host, Integer.TYPE, port, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "connect", InetAddress.class, address, Integer.TYPE, port, Void.TYPE);
        }
        catch (Exception e) {
            ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "connect", SocketAddress.class, address, Integer.TYPE, timeout, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "bind", InetAddress.class, host, Integer.TYPE, port, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void listen(int backlog) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "listen", Integer.TYPE, backlog, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "accept", SocketImpl.class, s, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        this.copyToDelegate();
        try {
            InputStream inputStream = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getInputStream", InputStream.class);
            return inputStream;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        this.copyToDelegate();
        try {
            OutputStream outputStream = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getOutputStream", OutputStream.class);
            return outputStream;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected int available() throws IOException {
        this.copyToDelegate();
        try {
            int n = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "available", Integer.TYPE);
            return n;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    protected void close() throws IOException {
        this.copyToDelegate();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "close", Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        this.copyToDelegate();
        try {
            this.delegate.setOption(optID, value);
        }
        finally {
            this.copyFromDelegate();
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        this.copyToDelegate();
        try {
            Object object = this.delegate.getOption(optID);
            return object;
        }
        finally {
            this.copyFromDelegate();
        }
    }
}

