/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.socket.Protocol;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.socket.TrafficCapturingNetworkConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;

public class SnifferInputStream
extends InputStream {
    private final SniffyNetworkConnection snifferSocket;
    private final TrafficCapturingNetworkConnection trafficCapturingNetworkConnection;
    private final InputStream delegate;

    public SnifferInputStream(TrafficCapturingNetworkConnection trafficCapturingNetworkConnection, InputStream delegate) {
        this.trafficCapturingNetworkConnection = trafficCapturingNetworkConnection;
        this.snifferSocket = trafficCapturingNetworkConnection instanceof SniffyNetworkConnection ? (SniffyNetworkConnection)trafficCapturingNetworkConnection : null;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        int bytesDown = 0;
        try {
            int read = this.delegate.read();
            if (read != -1) {
                bytesDown = 1;
                this.trafficCapturingNetworkConnection.logTraffic(false, Protocol.TCP, new byte[]{(byte)read}, 0, 1);
            }
            int n = read;
            return n;
        }
        finally {
            this.sleepIfRequired(bytesDown);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
            }
        }
    }

    private void sleepIfRequired(int bytesDown) throws ConnectException {
        if (null == this.snifferSocket) {
            return;
        }
        this.snifferSocket.setLastReadThreadId(Thread.currentThread().getId());
        if (this.snifferSocket.getLastReadThreadId() == this.snifferSocket.getLastWriteThreadId()) {
            this.snifferSocket.setPotentiallyBufferedOutputBytes(0);
        }
        int potentiallyBufferedInputBytes = this.snifferSocket.getPotentiallyBufferedInputBytes() - bytesDown;
        this.snifferSocket.setPotentiallyBufferedInputBytes(potentiallyBufferedInputBytes);
        if (potentiallyBufferedInputBytes < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedInputBytes / 212992;
            this.snifferSocket.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.snifferSocket.setPotentiallyBufferedInputBytes(212992);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        int bytesDown = 0;
        try {
            bytesDown = this.delegate.read(b);
            if (-1 != bytesDown) {
                this.trafficCapturingNetworkConnection.logTraffic(false, Protocol.TCP, b, 0, bytesDown);
            }
            int n = bytesDown;
            return n;
        }
        finally {
            this.sleepIfRequired(bytesDown);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        int bytesDown = 0;
        try {
            bytesDown = this.delegate.read(b, off, len);
            if (-1 != bytesDown) {
                this.trafficCapturingNetworkConnection.logTraffic(false, Protocol.TCP, b, off, bytesDown);
            }
            int n = bytesDown;
            return n;
        }
        finally {
            this.sleepIfRequired(bytesDown);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, bytesDown, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            long l = super.skip(n);
            return l;
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            int n = this.delegate.available();
            return n;
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.close();
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) {
        long start = System.currentTimeMillis();
        try {
            this.delegate.mark(readlimit);
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.reset();
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        long start = System.currentTimeMillis();
        try {
            boolean bl = this.delegate.markSupported();
            return bl;
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }
}

