/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.socket.Protocol;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.socket.TrafficCapturingNetworkConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;

public class SnifferOutputStream
extends OutputStream {
    private final SniffyNetworkConnection snifferSocket;
    private final TrafficCapturingNetworkConnection trafficCapturingNetworkConnection;
    private final OutputStream delegate;

    public SnifferOutputStream(TrafficCapturingNetworkConnection trafficCapturingNetworkConnection, OutputStream delegate) {
        this.trafficCapturingNetworkConnection = trafficCapturingNetworkConnection;
        this.snifferSocket = trafficCapturingNetworkConnection instanceof SniffyNetworkConnection ? (SniffyNetworkConnection)trafficCapturingNetworkConnection : null;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.write(b);
            this.trafficCapturingNetworkConnection.logTraffic(true, Protocol.TCP, new byte[]{(byte)b}, 0, 1);
        }
        finally {
            this.sleepIfRequired(1);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, 0, 1);
            }
        }
    }

    private void sleepIfRequired(int bytesUp) throws ConnectException {
        if (null == this.snifferSocket) {
            return;
        }
        this.snifferSocket.setLastWriteThreadId(Thread.currentThread().getId());
        if (this.snifferSocket.getLastReadThreadId() == this.snifferSocket.getLastWriteThreadId()) {
            this.snifferSocket.setPotentiallyBufferedInputBytes(0);
        }
        int potentiallyBufferedOutputBytes = this.snifferSocket.getPotentiallyBufferedOutputBytes() - bytesUp;
        this.snifferSocket.setPotentiallyBufferedOutputBytes(potentiallyBufferedOutputBytes);
        if (potentiallyBufferedOutputBytes < 0) {
            int estimatedNumberOfTcpPackets = 1 + -1 * potentiallyBufferedOutputBytes / 212992;
            this.snifferSocket.checkConnectionAllowed(estimatedNumberOfTcpPackets);
            this.snifferSocket.setPotentiallyBufferedOutputBytes(212992);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.write(b);
            this.trafficCapturingNetworkConnection.logTraffic(true, Protocol.TCP, b, 0, b.length);
        }
        finally {
            this.sleepIfRequired(b.length);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, 0, b.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.write(b, off, len);
            this.trafficCapturingNetworkConnection.logTraffic(true, Protocol.TCP, b, off, len);
        }
        finally {
            this.sleepIfRequired(len);
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start, 0, len);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(1);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.flush();
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.snifferSocket) {
            this.snifferSocket.checkConnectionAllowed(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.delegate.close();
        }
        finally {
            if (null != this.snifferSocket) {
                this.snifferSocket.logSocket(System.currentTimeMillis() - start);
            }
        }
    }
}

