/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.socket.CompatSnifferSocketImpl;
import io.sniffy.socket.Sleep;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.ReflectionUtil;
import java.io.IOException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.util.Set;

class SnifferSocketImpl
extends CompatSnifferSocketImpl {
    protected SnifferSocketImpl(SocketImpl delegate, Sleep sleep) {
        super(delegate, sleep);
    }

    protected SnifferSocketImpl(SocketImpl delegate) {
        this(delegate, new Sleep());
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        long start = System.currentTimeMillis();
        try {
            ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "setOption", SocketOption.class, name, Object.class, value, Void.TYPE);
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        long start = System.currentTimeMillis();
        try {
            Object object = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "getOption", SocketOption.class, name, Object.class);
            return (T)object;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    protected Set<SocketOption<?>> supportedOptions() {
        long start = System.currentTimeMillis();
        try {
            Set set = ReflectionUtil.invokeMethod(SocketImpl.class, this.delegate, "supportedOptions", Set.class);
            return set;
        }
        catch (Exception e) {
            throw ExceptionUtil.processException(e);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }
}

