/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.socket.CompatSnifferSocketImpl;
import io.sniffy.socket.SnifferSocketImpl;
import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.JVMUtil;
import io.sniffy.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class SnifferSocketImplFactory
implements SocketImplFactory {
    private static final Polyglog LOG = PolyglogFactory.log(SnifferSocketImplFactory.class);
    protected static final Constructor<? extends SocketImpl> defaultSocketImplClassConstructor = SnifferSocketImplFactory.getDefaultSocketImplClassConstructor();
    protected static final Method defaultSocketImplFactoryMethod = SnifferSocketImplFactory.getDefaultSocketImplFactoryMethod();
    private static volatile SocketImplFactory previousSocketImplFactory;

    public static void install() throws IOException {
        try {
            SocketImplFactory currentSocketImplFactory = (SocketImplFactory)ReflectionUtil.getField(Socket.class, null, "factory");
            LOG.info("Original SocketImplFactory was " + currentSocketImplFactory);
            if (null == currentSocketImplFactory || !SnifferSocketImplFactory.class.equals(currentSocketImplFactory.getClass())) {
                if (!ReflectionUtil.setField(Socket.class, null, "factory", null)) {
                    throw new IOException("Failed to uninstall SnifferSocketImplFactory");
                }
                SnifferSocketImplFactory snifferSocketImplFactory = new SnifferSocketImplFactory();
                Socket.setSocketImplFactory(snifferSocketImplFactory);
                LOG.info("SocketImplFactory set to " + snifferSocketImplFactory);
                previousSocketImplFactory = currentSocketImplFactory;
            }
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
            throw new IOException("Failed to initialize SnifferSocketImplFactory", e);
        }
        catch (NoSuchFieldException e) {
            LOG.error(e);
            throw new IOException("Failed to initialize SnifferSocketImplFactory", e);
        }
    }

    public static void uninstall() throws IOException {
        LOG.info("Uninstalling SniffySocketImplFactory - replacing with " + previousSocketImplFactory);
        if (!ReflectionUtil.setField(Socket.class, null, "factory", previousSocketImplFactory)) {
            LOG.error("Couldn't uninstall Sniffy SocketImplFactory");
            throw new IOException("Failed to uninstall SnifferSocketImplFactory");
        }
    }

    @Override
    public SocketImpl createSocketImpl() {
        SocketImpl socketImpl = SnifferSocketImplFactory.isServerSocketAccept() ? SnifferSocketImplFactory.newSocketImpl(false) : (SnifferSocketImplFactory.isServerSocket() ? SnifferSocketImplFactory.newSocketImpl(true) : (JVMUtil.getVersion() > 6 ? new SnifferSocketImpl(SnifferSocketImplFactory.newSocketImpl(false)) : new CompatSnifferSocketImpl(SnifferSocketImplFactory.newSocketImpl(false))));
        LOG.trace("Created SocketImpl " + socketImpl);
        return socketImpl;
    }

    private static boolean isServerSocketAccept() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("java.net.ServerSocket") && !ste.getClassName().startsWith("sun.security.ssl.SSLServerSocketImpl") || !ste.getMethodName().equals("accept")) continue;
            return true;
        }
        return false;
    }

    private static boolean isServerSocket() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("java.net.ServerSocket") && !ste.getClassName().startsWith("sun.security.ssl.SSLServerSocketImpl")) continue;
            return true;
        }
        return false;
    }

    private static SocketImpl newSocketImpl(boolean serverSocket) {
        SocketImpl originalSocketImpl = null;
        if (null != previousSocketImplFactory) {
            LOG.trace("Creating SocketImpl delegate using original SocketImplFactory " + previousSocketImplFactory);
            originalSocketImpl = previousSocketImplFactory.createSocketImpl();
        }
        if (null != defaultSocketImplClassConstructor) {
            try {
                LOG.trace("Creating SocketImpl delegate using original SocketImpl constructor " + defaultSocketImplClassConstructor);
                originalSocketImpl = defaultSocketImplClassConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.error(e);
                throw ExceptionUtil.throwException(e);
            }
        }
        if (null != defaultSocketImplFactoryMethod) {
            try {
                LOG.trace("Creating SocketImpl delegate using original SocketImpl factory method " + defaultSocketImplFactoryMethod);
                originalSocketImpl = (SocketImpl)defaultSocketImplFactoryMethod.invoke(null, serverSocket);
            }
            catch (IllegalAccessException e) {
                LOG.error(e);
                throw ExceptionUtil.throwException(e);
            }
            catch (InvocationTargetException e) {
                LOG.error(e);
                throw ExceptionUtil.throwException(e);
            }
        }
        return originalSocketImpl;
    }

    private static Class<? extends SocketImpl> getDefaultSocketImplClass() throws ClassNotFoundException {
        return Class.forName("java.net.SocksSocketImpl");
    }

    private static Constructor<? extends SocketImpl> getDefaultSocketImplClassConstructor() {
        Constructor<? extends SocketImpl> constructor;
        try {
            constructor = SnifferSocketImplFactory.getDefaultSocketImplClass().getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        ReflectionUtil.setAccessible(constructor);
        return constructor;
    }

    private static Class<?> getSocketImplClass() throws ClassNotFoundException {
        return Class.forName("java.net.SocketImpl");
    }

    private static Method getDefaultSocketImplFactoryMethod() {
        Method factoryMethod;
        try {
            factoryMethod = SnifferSocketImplFactory.getSocketImplClass().getDeclaredMethod("createPlatformSocketImpl", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        ReflectionUtil.setAccessible(factoryMethod);
        return factoryMethod;
    }
}

