/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.Sniffy;
import io.sniffy.SpyConfiguration;
import io.sniffy.log.Polyglog;
import io.sniffy.log.PolyglogFactory;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.socket.Protocol;
import io.sniffy.socket.SnifferInputStream;
import io.sniffy.socket.SnifferOutputStream;
import io.sniffy.socket.SniffyNetworkConnection;
import io.sniffy.socket.SniffySocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public class SniffySocket
extends SniffySocketAdapter
implements SniffyNetworkConnection {
    private static final Polyglog LOG = PolyglogFactory.log(SniffySocket.class);
    private final SocketChannel socketChannel;
    private InetSocketAddress address;
    private final int id;
    private volatile int potentiallyBufferedInputBytes = 0;
    private volatile int potentiallyBufferedOutputBytes = 0;
    private volatile long lastReadThreadId;
    private volatile long lastWriteThreadId;
    private volatile Integer connectionStatus;

    public SniffySocket(Socket delegate, SocketChannel socketChannel, int connectionId, InetSocketAddress address) throws SocketException {
        super(delegate);
        this.socketChannel = socketChannel;
        this.id = connectionId;
        this.address = null == address ? (InetSocketAddress)delegate.getRemoteSocketAddress() : address;
    }

    @Override
    public void setConnectionStatus(Integer connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    @Override
    @Deprecated
    public void logSocket(long millis) {
        this.logSocket(millis, 0, 0);
    }

    @Override
    @Deprecated
    public void logSocket(long millis, int bytesDown, int bytesUp) {
        Sniffy.SniffyMode sniffyMode = Sniffy.getSniffyMode();
        if (sniffyMode.isEnabled() && null != this.address && (millis > 0L || bytesDown > 0 || bytesUp > 0)) {
            Sniffy.logSocket(this.id, this.address, millis, bytesDown, bytesUp, sniffyMode.isCaptureStackTraces());
        }
    }

    @Override
    public void logTraffic(boolean sent, Protocol protocol, byte[] traffic, int off, int len) {
        SpyConfiguration effectiveSpyConfiguration = Sniffy.getEffectiveSpyConfiguration();
        if (effectiveSpyConfiguration.isCaptureNetworkTraffic()) {
            LOG.trace("SniffySocket.logTraffic() called; sent = " + sent + "; len = " + len + "; connectionId = " + this.id);
            Sniffy.logTraffic(this.id, this.address, sent, protocol, traffic, off, len, effectiveSpyConfiguration.isCaptureStackTraces());
        }
    }

    @Override
    public void checkConnectionAllowed() throws ConnectException {
        this.checkConnectionAllowed(0);
    }

    @Override
    public void checkConnectionAllowed(int numberOfSleepCycles) throws ConnectException {
        this.checkConnectionAllowed(this.address, numberOfSleepCycles);
    }

    @Override
    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress) throws ConnectException {
        this.checkConnectionAllowed(inetSocketAddress, 1);
    }

    @Override
    public void checkConnectionAllowed(InetSocketAddress inetSocketAddress, int numberOfSleepCycles) throws ConnectException {
        if (null != inetSocketAddress) {
            if (null == this.connectionStatus || ConnectionsRegistry.INSTANCE.isThreadLocal()) {
                this.connectionStatus = ConnectionsRegistry.INSTANCE.resolveSocketAddressStatus(inetSocketAddress, this);
            }
            if (this.connectionStatus < 0) {
                if (numberOfSleepCycles > 0 && -1 != this.connectionStatus) {
                    try {
                        SniffySocket.sleepImpl(-1 * this.connectionStatus * numberOfSleepCycles);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw new ConnectException(String.format("Connection to %s refused by Sniffy", inetSocketAddress));
            }
            if (numberOfSleepCycles > 0 && this.connectionStatus > 0) {
                try {
                    SniffySocket.sleepImpl(this.connectionStatus * numberOfSleepCycles);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static void sleepImpl(int millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress address) throws IOException {
        long start = System.currentTimeMillis();
        try {
            if (address instanceof InetSocketAddress) {
                this.address = (InetSocketAddress)address;
                this.checkConnectionAllowed(this.address);
            }
            super.connect(address);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress address, int timeout) throws IOException {
        long start = System.currentTimeMillis();
        try {
            if (address instanceof InetSocketAddress) {
                this.address = (InetSocketAddress)address;
                this.checkConnectionAllowed(this.address);
            }
            super.connect(address, timeout);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        long start = System.currentTimeMillis();
        try {
            super.bind(bindpoint);
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    @Override
    public SocketChannel getChannel() {
        return null != this.socketChannel ? this.socketChannel : super.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        long start = System.currentTimeMillis();
        this.checkConnectionAllowed();
        try {
            SnifferInputStream snifferInputStream = new SnifferInputStream(this, super.getInputStream());
            return snifferInputStream;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        long start = System.currentTimeMillis();
        this.checkConnectionAllowed();
        try {
            SnifferOutputStream snifferOutputStream = new SnifferOutputStream(this, super.getOutputStream());
            return snifferOutputStream;
        }
        finally {
            this.logSocket(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUrgentData(int data) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.checkConnectionAllowed(1);
            super.sendUrgentData(data);
            this.logSocket(System.currentTimeMillis() - start, 0, 1);
        }
        catch (Throwable throwable) {
            this.logSocket(System.currentTimeMillis() - start, 0, 1);
            this.logTraffic(true, Protocol.TCP, new byte[]{(byte)data}, 0, 1);
            throw throwable;
        }
        this.logTraffic(true, Protocol.TCP, new byte[]{(byte)data}, 0, 1);
    }

    @Override
    public int getPotentiallyBufferedInputBytes() {
        return this.potentiallyBufferedInputBytes;
    }

    @Override
    public void setPotentiallyBufferedInputBytes(int potentiallyBufferedInputBytes) {
        this.potentiallyBufferedInputBytes = potentiallyBufferedInputBytes;
    }

    @Override
    public int getPotentiallyBufferedOutputBytes() {
        return this.potentiallyBufferedOutputBytes;
    }

    @Override
    public void setPotentiallyBufferedOutputBytes(int potentiallyBufferedOutputBytes) {
        this.potentiallyBufferedOutputBytes = potentiallyBufferedOutputBytes;
    }

    @Override
    public long getLastReadThreadId() {
        return this.lastReadThreadId;
    }

    @Override
    public void setLastReadThreadId(long lastReadThreadId) {
        this.lastReadThreadId = lastReadThreadId;
    }

    @Override
    public long getLastWriteThreadId() {
        return this.lastWriteThreadId;
    }

    @Override
    public void setLastWriteThreadId(long lastWriteThreadId) {
        this.lastWriteThreadId = lastWriteThreadId;
    }
}

