/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.ThreadMetaData;
import io.sniffy.socket.Protocol;
import java.net.InetSocketAddress;

public class SocketMetaData {
    private final Protocol protocol;
    @Deprecated
    public final InetSocketAddress address;
    @Deprecated
    public final int connectionId;
    @Deprecated
    public final String stackTrace;
    @Deprecated
    public final long ownerThreadId;
    private final ThreadMetaData threadMetaData;
    private final int hashCode;

    public SocketMetaData(Protocol protocol, InetSocketAddress address, int connectionId) {
        this(protocol, address, connectionId, null, (ThreadMetaData)null);
    }

    public SocketMetaData(InetSocketAddress address, int connectionId, String stackTrace, Thread ownerThread) {
        this(Protocol.TCP, address, connectionId, stackTrace, ThreadMetaData.create(ownerThread));
    }

    public SocketMetaData(Protocol protocol, InetSocketAddress address, int connectionId, String stackTrace, Thread ownerThread) {
        this(protocol, address, connectionId, stackTrace, null == ownerThread ? null : ThreadMetaData.create(ownerThread));
    }

    public SocketMetaData(Protocol protocol, InetSocketAddress address, int connectionId, String stackTrace, ThreadMetaData threadMetaData) {
        this.protocol = protocol;
        this.address = address;
        this.connectionId = connectionId;
        this.stackTrace = null == stackTrace ? null : stackTrace.intern();
        this.threadMetaData = threadMetaData;
        this.ownerThreadId = null == threadMetaData ? -1L : threadMetaData.getThreadId();
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.protocol.hashCode();
        result = 31 * result + this.connectionId;
        result = 31 * result + System.identityHashCode(this.stackTrace);
        result = 31 * result + (int)(this.ownerThreadId ^ this.ownerThreadId >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketMetaData that = (SocketMetaData)o;
        if (this.connectionId != that.connectionId) {
            return false;
        }
        if (this.ownerThreadId != that.ownerThreadId) {
            return false;
        }
        if (!this.protocol.equals((Object)that.protocol)) {
            return false;
        }
        if (!this.address.equals(that.address)) {
            return false;
        }
        return this.stackTrace == that.stackTrace;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Deprecated
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Deprecated
    public ThreadMetaData getThreadMetaData() {
        return this.threadMetaData;
    }
}

