/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import java.util.concurrent.atomic.AtomicLong;

public class SocketStats {
    public final AtomicLong elapsedTime = new AtomicLong();
    public final AtomicLong bytesDown = new AtomicLong();
    public final AtomicLong bytesUp = new AtomicLong();

    public SocketStats(SocketStats that) {
        this.accumulate(that);
    }

    public SocketStats(long elapsedTime, long bytesDown, long bytesUp) {
        this.elapsedTime.set(elapsedTime);
        this.bytesDown.set(Math.max(bytesDown, 0L));
        this.bytesUp.set(Math.max(bytesUp, 0L));
    }

    public void accumulate(long elapsedTime, int bytesDown, int bytesUp) {
        this.elapsedTime.addAndGet(elapsedTime);
        this.bytesDown.addAndGet(Math.max(bytesDown, 0));
        this.bytesUp.addAndGet(Math.max(bytesUp, 0));
    }

    public void accumulate(SocketStats that) {
        this.accumulate(that.elapsedTime.longValue(), that.bytesDown.intValue(), that.bytesUp.intValue());
    }
}

