/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.Spy;
import io.sniffy.ThreadMatcher;
import io.sniffy.Threads;
import io.sniffy.socket.AddressMatcher;
import io.sniffy.socket.AddressMatchers;
import io.sniffy.socket.SocketMetaData;
import io.sniffy.socket.SocketStats;
import io.sniffy.socket.TcpConnectionsExpectationError;
import java.util.HashSet;
import java.util.Map;

public class TcpConnections {
    private TcpConnections() {
    }

    public static TcpExpectation_Count none() {
        return TcpConnections.exact(0);
    }

    public static TcpExpectation_Count atMostOnce() {
        return TcpConnections.between(0, 1);
    }

    public static TcpExpectation_Count exact(int count) {
        return TcpConnections.between(count, count);
    }

    public static TcpExpectation_Count between(int min, int max) {
        return new TcpExpectation_Count(min, max);
    }

    public static TcpExpectation_Min min(int min) {
        return new TcpExpectation_Min(min);
    }

    public static TcpExpectation_Max max(int max) {
        return new TcpExpectation_Max(max);
    }

    public static class TcpExpectation_Count_Threads
    extends TcpExpectation {
        private TcpExpectation_Count_Threads(int min, int max, Threads threads) {
            super(min, max, threads, AddressMatchers.anyAddressMatcher());
        }

        public TcpExpectation host(String host) {
            return new TcpExpectation(this.min, this.max, this.threads, AddressMatchers.exactAddressMatcher(host));
        }

        public TcpExpectation addressMatcher(AddressMatcher addressMatcher) {
            return new TcpExpectation(this.min, this.max, this.threads, addressMatcher);
        }
    }

    public static class TcpExpectation_Count_AddressMatcher
    extends TcpExpectation {
        private TcpExpectation_Count_AddressMatcher(int min, int max, AddressMatcher addressMatcher) {
            super(min, max, Threads.CURRENT, addressMatcher);
        }

        public TcpExpectation threads(Threads threads) {
            return new TcpExpectation(this.min, this.max, threads, this.addressMatcher);
        }

        public TcpExpectation currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public TcpExpectation otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public TcpExpectation anyThreads() {
            return this.threads(Threads.ANY);
        }
    }

    public static class TcpExpectation_Count
    extends TcpExpectation {
        private TcpExpectation_Count(int min, int max) {
            super(min, max, Threads.CURRENT, AddressMatchers.anyAddressMatcher());
            if (min < 0) {
                throw new IllegalArgumentException("min cannot be negative");
            }
            if (max < min) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
        }

        public TcpExpectation_Count_AddressMatcher host(String host) {
            return new TcpExpectation_Count_AddressMatcher(this.min, this.max, AddressMatchers.exactAddressMatcher(host));
        }

        public TcpExpectation_Count_AddressMatcher addressMatcher(AddressMatcher addressMatcher) {
            return new TcpExpectation_Count_AddressMatcher(this.min, this.max, addressMatcher);
        }

        public TcpExpectation_Count_Threads threads(Threads threads) {
            return new TcpExpectation_Count_Threads(this.min, this.max, threads);
        }

        public TcpExpectation_Count_Threads currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public TcpExpectation_Count_Threads otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public TcpExpectation_Count_Threads anyThreads() {
            return this.threads(Threads.ANY);
        }
    }

    public static class TcpExpectation_Max
    extends TcpExpectation_Count {
        private TcpExpectation_Max(int max) {
            super(0, max);
        }

        public TcpExpectation_Count min(int min) {
            if (this.max < min) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new TcpExpectation_Count(min, this.max);
        }
    }

    public static class TcpExpectation_Min
    extends TcpExpectation_Count {
        private TcpExpectation_Min(int min) {
            super(min, Integer.MAX_VALUE);
        }

        public TcpExpectation_Count max(int max) {
            if (max < this.min) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new TcpExpectation_Count(this.min, max);
        }
    }

    public static class TcpExpectation
    implements Spy.Expectation {
        protected final int min;
        protected final int max;
        protected final Threads threads;
        protected final AddressMatcher addressMatcher;

        public TcpExpectation(int min, int max, Threads threads, AddressMatcher addressMatcher) {
            this.min = min;
            this.max = max;
            this.threads = threads;
            this.addressMatcher = addressMatcher;
        }

        @Override
        public <T extends Spy<T>> Spy<T> verify(Spy<T> spy) throws TcpConnectionsExpectationError {
            Map<SocketMetaData, SocketStats> socketOperations = spy.getSocketOperations((ThreadMatcher)this.threads, this.addressMatcher, true);
            HashSet<Integer> connectionIds = new HashSet<Integer>();
            for (SocketMetaData socketMetaData : socketOperations.keySet()) {
                connectionIds.add(socketMetaData.connectionId);
            }
            int numConnections = connectionIds.size();
            if (-1 != this.max && numConnections > this.max || -1 != this.min && numConnections < this.min) {
                throw new TcpConnectionsExpectationError(this, socketOperations, numConnections);
            }
            return spy;
        }
    }
}

