/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.socket;

import io.sniffy.SniffyAssertionError;
import io.sniffy.socket.SocketMetaData;
import io.sniffy.socket.SocketStats;
import io.sniffy.socket.TcpConnections;
import io.sniffy.util.StringUtil;
import java.util.Map;

public class TcpConnectionsExpectationError
extends SniffyAssertionError {
    private final TcpConnections.TcpExpectation tcpExpectation;
    private final Map<SocketMetaData, SocketStats> socketOperations;
    private final int numConnections;

    public TcpConnectionsExpectationError(TcpConnections.TcpExpectation tcpExpectation, Map<SocketMetaData, SocketStats> socketOperations, int numConnections) {
        super(TcpConnectionsExpectationError.buildDetailsMessage(tcpExpectation, socketOperations, numConnections));
        this.tcpExpectation = tcpExpectation;
        this.socketOperations = socketOperations;
        this.numConnections = numConnections;
    }

    public TcpConnections.TcpExpectation getTcpExpectation() {
        return this.tcpExpectation;
    }

    public Map<SocketMetaData, SocketStats> getSocketOperations() {
        return this.socketOperations;
    }

    public int getNumConnections() {
        return this.numConnections;
    }

    private static String buildDetailsMessage(TcpConnections.TcpExpectation tcpExpectation, Map<SocketMetaData, SocketStats> socketOperations, int numConnections) {
        StringBuilder sb = new StringBuilder();
        sb.append("Expected between ").append(tcpExpectation.min).append(" and ").append(tcpExpectation.max);
        tcpExpectation.threads.describe(sb);
        if (null != tcpExpectation.addressMatcher) {
            tcpExpectation.addressMatcher.describe(sb);
        }
        sb.append(" connections").append(StringUtil.LINE_SEPARATOR);
        sb.append("Observed ").append(numConnections).append(" connections instead:").append(StringUtil.LINE_SEPARATOR);
        for (Map.Entry<SocketMetaData, SocketStats> entry : socketOperations.entrySet()) {
            SocketMetaData socketMetaData = entry.getKey();
            SocketStats socketStats = entry.getValue();
            sb.append("Connection #").append(socketMetaData.connectionId).append(" to ").append(socketMetaData.address).append(" sent ").append(socketStats.bytesUp).append(" bytes and received ").append(socketStats.bytesDown);
        }
        return sb.toString();
    }
}

