/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.sql.ConnectionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Wrapper;

public class JdbcInvocationHandler<T extends Wrapper>
implements InvocationHandler {
    public static final String GET_CONNECTION_METHOD = "getConnection";
    public static final String CREATE_STATEMENT_METHOD = "createStatement";
    public static final String PREPARE_STATEMENT_METHOD = "prepareStatement";
    public static final String PREPARE_CALL_METHOD = "prepareCall";
    public static final String EQUALS_METHOD = "equals";
    protected final Connection connectionProxy;
    protected final T delegate;

    protected JdbcInvocationHandler(Connection connectionProxy, T delegate) {
        this.connectionProxy = connectionProxy;
        this.delegate = delegate;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<Connection> returnType = method.getReturnType();
        if (this.connectionProxy != null && GET_CONNECTION_METHOD.equals(methodName) && returnType.isAssignableFrom(Connection.class)) {
            return this.connectionProxy;
        }
        if (EQUALS_METHOD.equals(methodName)) {
            Object that = args[0];
            if (null == that) {
                return Boolean.FALSE;
            }
            if (Proxy.isProxyClass(that.getClass())) {
                InvocationHandler thatInvocationHandler = Proxy.getInvocationHandler(that);
                if (thatInvocationHandler instanceof JdbcInvocationHandler) {
                    return this.delegate.equals(((JdbcInvocationHandler)thatInvocationHandler).delegate);
                }
                return Boolean.FALSE;
            }
            return this.invokeTargetImpl(method, args);
        }
        return this.invokeImpl((Wrapper)proxy, methodName, method, args);
    }

    protected Object invokeImpl(T proxy, String methodName, Method method, Object[] args) throws Throwable {
        Object result = this.invokeTarget(method, args);
        if (CREATE_STATEMENT_METHOD.equals(methodName)) {
            return Proxy.newProxyInstance(ConnectionInvocationHandler.class.getClassLoader(), new Class[]{Statement.class}, new JdbcInvocationHandler<Statement>(this.connectionProxy, (Statement)result));
        }
        if (PREPARE_STATEMENT_METHOD.equals(methodName)) {
            return Proxy.newProxyInstance(ConnectionInvocationHandler.class.getClassLoader(), new Class[]{PreparedStatement.class}, new JdbcInvocationHandler<PreparedStatement>(this.connectionProxy, (PreparedStatement)result));
        }
        if (PREPARE_CALL_METHOD.equals(methodName)) {
            return Proxy.newProxyInstance(ConnectionInvocationHandler.class.getClassLoader(), new Class[]{CallableStatement.class}, new JdbcInvocationHandler<CallableStatement>(this.connectionProxy, (CallableStatement)result));
        }
        return result;
    }

    protected Object invokeTarget(Method method, Object[] args) throws Throwable {
        return this.invokeTargetImpl(method, args);
    }

    protected Object invokeTargetImpl(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

