/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.Sniffy;
import io.sniffy.sql.ConnectionInvocationHandler;
import io.sniffy.sql.SniffyDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import javax.sql.PooledConnection;

class PooledConnectionInvocationHandler
implements InvocationHandler {
    private final PooledConnection delegate;
    private static final Method GET_CONNECTION_METHOD;

    PooledConnectionInvocationHandler(PooledConnection delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getConnection".equals(method.getName())) {
            long start = System.currentTimeMillis();
            try {
                Sniffy.enterJdbcMethod();
                Connection targetConnection = (Connection)Connection.class.cast(method.invoke((Object)this.delegate, args));
                String url = targetConnection.getMetaData().getURL();
                String userName = targetConnection.getMetaData().getUserName();
                SniffyDriver.checkConnectionAllowed(targetConnection, url, userName);
                Object t = Connection.class.cast(Proxy.newProxyInstance(PooledConnectionInvocationHandler.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(targetConnection, url, userName)));
                return t;
            }
            finally {
                Sniffy.exitJdbcMethod(GET_CONNECTION_METHOD, System.currentTimeMillis() - start);
            }
        }
        return method.invoke((Object)this.delegate, args);
    }

    static {
        Method getConnectionMethod;
        try {
            getConnectionMethod = PooledConnection.class.getMethod("getConnection", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getConnectionMethod = null;
        }
        GET_CONNECTION_METHOD = getConnectionMethod;
    }
}

