/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.sql.StatementInvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;

class PreparedStatementInvocationHandler<T extends PreparedStatement>
extends StatementInvocationHandler<T> {
    private final String sql;

    PreparedStatementInvocationHandler(T delegate, Connection sniffyConnectionProxy, String url, String userName, String sql) {
        super(delegate, sniffyConnectionProxy, url, userName);
        this.sql = sql;
    }

    @Override
    public Object invokeImpl(T proxy, String methodName, Method method, Object[] args) throws Throwable {
        Object result;
        this.checkConnectionAllowed();
        switch (StatementInvocationHandler.StatementMethodType.parse(method.getName())) {
            case ADD_BATCH: {
                this.addBatch(this.sql);
                result = this.invokeTarget(method, args);
                break;
            }
            case CLEAR_BATCH: {
                this.clearBatch();
                result = this.invokeTarget(method, args);
                break;
            }
            case EXECUTE_BATCH: {
                result = this.invokeTargetAndRecord(method, args, this.getBatchedSql(), true);
                break;
            }
            case EXECUTE_UPDATE: {
                result = this.invokeTargetAndRecord(method, args, null != args && args.length > 0 ? (String)String.class.cast(args[0]) : this.sql, true);
                break;
            }
            case EXECUTE_SQL: {
                result = this.invokeTargetAndRecord(method, args, null != args && args.length > 0 ? (String)String.class.cast(args[0]) : this.sql, false);
                break;
            }
            default: {
                result = this.invokeTarget(method, args);
            }
        }
        return this.proxyResultSet(result);
    }

    @Override
    protected synchronized String getBatchedSql() {
        String batchedSql = super.getBatchedSql();
        return null == batchedSql ? this.sql : batchedSql;
    }
}

