/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.Sniffy;
import io.sniffy.sql.SniffyInvocationHandler;
import io.sniffy.sql.StatementMetaData;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;

class ResultSetInvocationHandler<T extends ResultSet>
extends SniffyInvocationHandler<T> {
    private final StatementMetaData statementMetaData;

    ResultSetInvocationHandler(T delegate, Connection connectionProxy, String url, String userName, StatementMetaData statementMetaData) {
        super(connectionProxy, delegate, url, userName);
        this.statementMetaData = statementMetaData;
    }

    @Override
    public Object invokeImpl(T proxy, String methodName, Method method, Object[] args) throws Throwable {
        this.checkConnectionAllowed();
        if ("next".equals(methodName) || "previous".equals(methodName) || "first".equals(methodName) || "last".equals(methodName) || "absolute".equals(methodName) || "relative".equals(methodName)) {
            return this.invokeTargetAndRecord(method, args);
        }
        return this.invokeTarget(method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeTargetAndRecord(Method method, Object[] args) throws Throwable {
        if (Sniffy.hasSpies()) {
            long start = System.currentTimeMillis();
            try {
                Sniffy.enterJdbcMethod();
                Object result = this.invokeTargetImpl(method, args);
                if (Boolean.TRUE.equals(result)) {
                    Sniffy.readDatabaseRow(method, System.currentTimeMillis() - start, this.statementMetaData);
                }
                Object object = result;
                return object;
            }
            finally {
                Sniffy.exitJdbcMethod(method, System.currentTimeMillis() - start);
            }
        }
        return this.invokeTargetImpl(method, args);
    }
}

