/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.Sniffy;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.sql.ConnectionInvocationHandler;
import io.sniffy.sql.PooledConnectionInvocationHandler;
import io.sniffy.sql.SniffyDriver;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class SniffyDataSource
implements DataSource,
XADataSource,
ConnectionPoolDataSource {
    private static final Method GET_CONNECTION_METHOD = SniffyDataSource.getMethod(DataSource.class, "getConnection");
    private static final Method GET_CONNECTION_WITH_CREDENTIALS_METHOD = SniffyDataSource.getMethod(DataSource.class, "getConnection", String.class, String.class);
    private static final Method GET_CONNECTION_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getConnection");
    private static final Method GET_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getConnection", String.class, String.class);
    private static final Method GET_XA_CONNECTION_METHOD = SniffyDataSource.getMethod(XADataSource.class, "getXAConnection");
    private static final Method GET_XA_CONNECTION_WITH_CREDENTIALS_METHOD = SniffyDataSource.getMethod(XADataSource.class, "getXAConnection", String.class, String.class);
    private static final Method GET_XA_CONNECTION_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getXAConnection");
    private static final Method GET_XA_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getXAConnection", String.class, String.class);
    private static final Method GET_POOLED_CONNECTION_METHOD = SniffyDataSource.getMethod(ConnectionPoolDataSource.class, "getPooledConnection");
    private static final Method GET_POOLED_CONNECTION_WITH_CREDENTIALS_METHOD = SniffyDataSource.getMethod(ConnectionPoolDataSource.class, "getPooledConnection", String.class, String.class);
    private static final Method GET_POOLED_CONNECTION_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getPooledConnection");
    private static final Method GET_POOLED_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL = SniffyDataSource.getMethod(SniffyDataSource.class, "getPooledConnection", String.class, String.class);
    private final CommonDataSource target;
    private final DataSource dataSource;
    private final XADataSource xaDataSource;
    private final ConnectionPoolDataSource connectionPoolDataSource;

    private static Method getMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
        try {
            return clazz.getMethod(methodName, arguments);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T extends CommonDataSource, R extends DataSource & XADataSource> R wrap(T target) {
        return (R)new SniffyDataSource(target);
    }

    public <T extends CommonDataSource> SniffyDataSource(T target) {
        this.target = target;
        this.dataSource = target instanceof DataSource ? (DataSource)DataSource.class.cast(target) : null;
        this.xaDataSource = target instanceof XADataSource ? (XADataSource)XADataSource.class.cast(target) : null;
        this.connectionPoolDataSource = target instanceof ConnectionPoolDataSource ? (ConnectionPoolDataSource)ConnectionPoolDataSource.class.cast(target) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        String userName;
        String url;
        Connection delegateConnection;
        if (null == this.dataSource) {
            throw new SQLException("Target is not a DataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.dataSource.getConnection();
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            delegateConnection = this.dataSource.getConnection();
            url = delegateConnection.getMetaData().getURL();
            userName = delegateConnection.getMetaData().getUserName();
            SniffyDriver.checkConnectionAllowed(url, userName);
        }
        finally {
            Sniffy.exitJdbcMethod(GET_CONNECTION_METHOD, System.currentTimeMillis() - start, GET_CONNECTION_METHOD_IMPL);
        }
        return (Connection)Connection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(delegateConnection, url, userName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        String url;
        Connection delegateConnection;
        if (null == this.dataSource) {
            throw new SQLException("Target is not a DataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.dataSource.getConnection(userName, password);
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            delegateConnection = this.dataSource.getConnection(userName, password);
            url = delegateConnection.getMetaData().getURL();
            SniffyDriver.checkConnectionAllowed(url, userName);
        }
        finally {
            Sniffy.exitJdbcMethod(GET_CONNECTION_WITH_CREDENTIALS_METHOD, System.currentTimeMillis() - start, GET_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL);
        }
        return (Connection)Connection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(delegateConnection, url, userName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (null == this.dataSource) {
            throw new SQLException("Target is not a XADataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.xaDataSource.getXAConnection();
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            XAConnection xAConnection = (XAConnection)XAConnection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{XAConnection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(this.xaDataSource.getXAConnection())));
            return xAConnection;
        }
        finally {
            Sniffy.exitJdbcMethod(GET_XA_CONNECTION_METHOD, System.currentTimeMillis() - start, GET_XA_CONNECTION_METHOD_IMPL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (null == this.dataSource) {
            throw new SQLException("Target is not a XADataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.xaDataSource.getXAConnection(user, password);
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            XAConnection xAConnection = (XAConnection)XAConnection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{XAConnection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(this.xaDataSource.getXAConnection(user, password))));
            return xAConnection;
        }
        finally {
            Sniffy.exitJdbcMethod(GET_XA_CONNECTION_WITH_CREDENTIALS_METHOD, System.currentTimeMillis() - start, GET_XA_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (null == this.connectionPoolDataSource) {
            throw new SQLException("Target is not a ConnectionPoolDataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.connectionPoolDataSource.getPooledConnection();
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            PooledConnection pooledConnection = (PooledConnection)PooledConnection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{PooledConnection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(this.connectionPoolDataSource.getPooledConnection())));
            return pooledConnection;
        }
        finally {
            Sniffy.exitJdbcMethod(GET_POOLED_CONNECTION_METHOD, System.currentTimeMillis() - start, GET_POOLED_CONNECTION_METHOD_IMPL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (null == this.connectionPoolDataSource) {
            throw new SQLException("Target is not a ConnectionPoolDataSource instance");
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return this.connectionPoolDataSource.getPooledConnection(user, password);
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            PooledConnection pooledConnection = (PooledConnection)PooledConnection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{PooledConnection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(this.connectionPoolDataSource.getPooledConnection(user, password))));
            return pooledConnection;
        }
        finally {
            Sniffy.exitJdbcMethod(GET_POOLED_CONNECTION_WITH_CREDENTIALS_METHOD, System.currentTimeMillis() - start, GET_POOLED_CONNECTION_WITH_CREDENTIALS_METHOD_IMPL);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    @IgnoreJRERequirement
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.target.getClass())) {
            return iface.cast(this.target);
        }
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.target.getClass()) || this.dataSource.isWrapperFor(iface);
    }
}

