/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.Constants;
import io.sniffy.Sniffy;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.sql.ConnectionInvocationHandler;
import io.sniffy.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class SniffyDriver
implements Driver,
Constants {
    private static final SniffyDriver INSTANCE;
    private static final Method CONNECT_METHOD;
    private static final Method CONNECT_METHOD_IMPL;

    private static void load() {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Sniffy.initialize();
    }

    protected static void checkConnectionAllowed(Connection connection, String url, String userName) throws SQLException {
        if (SniffyDriver.resolveDataSourceStatus(url, userName) < 0) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException(String.format("Connection to %s (%s) refused by Sniffy", url, userName));
        }
    }

    private static Integer resolveDataSourceStatus(String url, String userName) {
        return ConnectionsRegistry.INSTANCE.resolveDataSourceStatus(url, userName);
    }

    protected static void checkConnectionAllowed(String url, String userName) throws SQLException {
        SniffyDriver.checkConnectionAllowed(url, userName, false);
    }

    protected static void checkConnectionAllowed(String url, String userName, boolean sleep) throws SQLException {
        int status = SniffyDriver.resolveDataSourceStatus(url, userName);
        if (status < 0) {
            if (sleep && -1 != status) {
                try {
                    SniffyDriver.sleepImpl(-1 * status);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new SQLException(String.format("Connection to %s (%s) refused by Sniffy", url, userName));
        }
        if (sleep && status > 0) {
            try {
                SniffyDriver.sleepImpl(status);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void sleepImpl(int status) throws InterruptedException {
        Thread.sleep(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Driver originDriver;
        if (null == url || !this.acceptsURL(url)) {
            return null;
        }
        String originUrl = this.extractOriginUrl(url);
        String userName = info.getProperty("user");
        SniffyDriver.checkConnectionAllowed(originUrl, userName, true);
        try {
            originDriver = DriverManager.getDriver(originUrl);
        }
        catch (SQLException e) {
            try {
                this.reloadServiceProviders();
                originDriver = DriverManager.getDriver(originUrl);
            }
            catch (Exception e2) {
                throw e;
            }
        }
        if (!SniffyConfiguration.INSTANCE.isMonitorJdbc()) {
            return originDriver.connect(originUrl, info);
        }
        long start = System.currentTimeMillis();
        try {
            Sniffy.enterJdbcMethod();
            Connection delegateConnection = originDriver.connect(originUrl, info);
            Connection connection = (Connection)Connection.class.cast(Proxy.newProxyInstance(SniffyDriver.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(delegateConnection, originUrl, userName)));
            return connection;
        }
        finally {
            Sniffy.exitJdbcMethod(CONNECT_METHOD, System.currentTimeMillis() - start, CONNECT_METHOD_IMPL);
        }
    }

    private void reloadServiceProviders() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
                Iterator<Driver> driversIterator = loadedDrivers.iterator();
                try {
                    while (driversIterator.hasNext()) {
                        driversIterator.next();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private Driver getOriginDriver(String url) throws SQLException {
        String originUrl = this.extractOriginUrl(url);
        return DriverManager.getDriver(originUrl);
    }

    protected String extractOriginUrl(String url) {
        if (null == url) {
            return null;
        }
        if (url.startsWith("sniffy:")) {
            return url.substring("sniffy:".length());
        }
        return url;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return null != url && url.startsWith("sniffy:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver originDriver = this.getOriginDriver(url);
        return originDriver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        String message = "getParentLogger() method is not implemented in Sniffy";
        if (!ExceptionUtil.throwException("java.sql.SQLFeatureNotSupportedException", message)) {
            throw new UnsupportedOperationException(message);
        }
        return null;
    }

    static {
        Method getConnectionMethodImpl;
        Method getConnectionMethod;
        INSTANCE = new SniffyDriver();
        try {
            getConnectionMethod = Driver.class.getMethod("connect", String.class, Properties.class);
        }
        catch (NoSuchMethodException e) {
            getConnectionMethod = null;
        }
        CONNECT_METHOD = getConnectionMethod;
        try {
            getConnectionMethodImpl = SniffyDriver.class.getMethod("connect", String.class, Properties.class);
        }
        catch (NoSuchMethodException e) {
            getConnectionMethodImpl = null;
        }
        CONNECT_METHOD_IMPL = getConnectionMethodImpl;
        SniffyDriver.load();
    }
}

