/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.SniffyAssertionError;
import io.sniffy.Spy;
import io.sniffy.Threads;
import io.sniffy.sql.SqlStatement;
import io.sniffy.sql.SqlStats;
import io.sniffy.sql.StatementMetaData;
import io.sniffy.sql.WrongNumberOfQueriesError;
import io.sniffy.sql.WrongNumberOfRowsError;
import java.util.Map;

public class SqlQueries {
    private SqlQueries() {
    }

    public static SqlExpectation_CountQueries noneQueries() {
        return SqlQueries.exactQueries(0);
    }

    public static SqlExpectation_CountQueries atMostOneQuery() {
        return SqlQueries.queriesBetween(0, 1);
    }

    public static SqlExpectation_CountQueries exactQueries(int countQueries) {
        return SqlQueries.queriesBetween(countQueries, countQueries);
    }

    public static SqlExpectation_CountQueries queriesBetween(int minQueries, int maxQueries) {
        return new SqlExpectation_CountQueries(minQueries, maxQueries);
    }

    public static SqlExpectation_MinQueries minQueries(int minQueries) {
        return new SqlExpectation_MinQueries(minQueries);
    }

    public static SqlExpectation_MaxQueries maxQueries(int maxQueries) {
        return new SqlExpectation_MaxQueries(maxQueries);
    }

    public static SqlExpectation_CountRows noneRows() {
        return SqlQueries.exactRows(0);
    }

    public static SqlExpectation_CountRows atMostOneRow() {
        return SqlQueries.rowsBetween(0, 1);
    }

    public static SqlExpectation_CountRows exactRows(int countRows) {
        return SqlQueries.rowsBetween(countRows, countRows);
    }

    public static SqlExpectation_CountRows rowsBetween(int minRows, int maxRows) {
        return new SqlExpectation_CountRows(minRows, maxRows);
    }

    public static SqlExpectation_MinRows minRows(int minRows) {
        return new SqlExpectation_MinRows(minRows);
    }

    public static SqlExpectation_MaxRows maxRows(int maxRows) {
        return new SqlExpectation_MaxRows(maxRows);
    }

    public static class SqlExpectation_CountRows_Threads_QueryType_MaxQueries
    extends SqlExpectation {
        private SqlExpectation_CountRows_Threads_QueryType_MaxQueries(int minRows, int maxRows, int maxQueries, Threads threads, SqlStatement type) {
            super(0, maxQueries, minRows, maxRows, threads, type);
        }

        public SqlExpectation minQueries(int minQueries) {
            if (this.maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation(minQueries, this.maxQueries, this.minRows, this.maxRows, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountRows_Threads_QueryType_MinQueries
    extends SqlExpectation {
        private SqlExpectation_CountRows_Threads_QueryType_MinQueries(int minRows, int maxRows, int minQueries, Threads threads, SqlStatement type) {
            super(minQueries, Integer.MAX_VALUE, minRows, maxRows, threads, type);
        }

        public SqlExpectation maxQueries(int maxQueries) {
            if (maxQueries < this.minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation(this.minQueries, maxQueries, this.minRows, this.maxRows, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountRows_Threads_QueryType
    extends SqlExpectation {
        private SqlExpectation_CountRows_Threads_QueryType(int minRows, int maxRows, Threads threads, SqlStatement queryType) {
            super(0, Integer.MAX_VALUE, minRows, maxRows, threads, queryType);
        }

        public SqlExpectation noneQueries() {
            return this.exactQueries(0);
        }

        public SqlExpectation atMostOneQuery() {
            return this.queriesBetween(0, 1);
        }

        public SqlExpectation exactQueries(int countQueries) {
            return this.queriesBetween(countQueries, countQueries);
        }

        public SqlExpectation queriesBetween(int minQueries, int maxQueries) {
            return new SqlExpectation(minQueries, maxQueries, this.minRows, this.maxRows, this.threads, this.type);
        }

        public SqlExpectation_CountRows_Threads_QueryType_MinQueries minQueries(int minQueries) {
            return new SqlExpectation_CountRows_Threads_QueryType_MinQueries(this.minRows, this.maxRows, minQueries, this.threads, this.type);
        }

        public SqlExpectation_CountRows_Threads_QueryType_MaxQueries maxQueries(int maxQueries) {
            return new SqlExpectation_CountRows_Threads_QueryType_MaxQueries(this.minRows, this.maxRows, maxQueries, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_Threads_QueryType_MaxRows
    extends SqlExpectation {
        private SqlExpectation_CountQueries_Threads_QueryType_MaxRows(int minQueries, int maxQueries, int maxRows, Threads threads, SqlStatement type) {
            super(minQueries, maxQueries, 0, maxRows, threads, type);
        }

        public SqlExpectation minRows(int minRows) {
            if (this.maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation(this.minQueries, this.maxQueries, minRows, this.maxRows, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_Threads_QueryType_MinRows
    extends SqlExpectation {
        private SqlExpectation_CountQueries_Threads_QueryType_MinRows(int minQueries, int maxQueries, int minRows, Threads threads, SqlStatement type) {
            super(minQueries, maxQueries, minRows, Integer.MAX_VALUE, threads, type);
        }

        public SqlExpectation maxRows(int maxRows) {
            if (maxRows < this.minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation(this.minQueries, this.maxQueries, this.minRows, maxRows, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_Threads_QueryType
    extends SqlExpectation {
        private SqlExpectation_CountQueries_Threads_QueryType(int minQueries, int maxQueries, Threads threads, SqlStatement queryType) {
            super(minQueries, maxQueries, 0, Integer.MAX_VALUE, threads, queryType);
        }

        public SqlExpectation noneRows() {
            return this.exactRows(0);
        }

        public SqlExpectation atMostOneRow() {
            return this.rowsBetween(0, 1);
        }

        public SqlExpectation exactRows(int countRows) {
            return this.rowsBetween(countRows, countRows);
        }

        public SqlExpectation rowsBetween(int minRows, int maxRows) {
            return new SqlExpectation(this.minQueries, this.maxQueries, minRows, maxRows, this.threads, this.type);
        }

        public SqlExpectation_CountQueries_Threads_QueryType_MinRows minRows(int minRows) {
            return new SqlExpectation_CountQueries_Threads_QueryType_MinRows(this.minQueries, this.maxQueries, minRows, this.threads, this.type);
        }

        public SqlExpectation_CountQueries_Threads_QueryType_MaxRows maxRows(int maxRows) {
            return new SqlExpectation_CountQueries_Threads_QueryType_MaxRows(this.minQueries, this.maxQueries, maxRows, this.threads, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_MaxRows_Threads
    extends SqlExpectation_CountQueries_CountRows_Threads {
        private SqlExpectation_CountQueries_MaxRows_Threads(int minQueries, int maxQueries, int maxRows, Threads threads) {
            super(minQueries, maxQueries, 0, maxRows, threads);
        }

        public SqlExpectation_CountQueries_CountRows_Threads minRows(int minRows) {
            if (this.maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_Threads(this.minQueries, this.maxQueries, minRows, this.maxRows, this.threads);
        }
    }

    public static class SqlExpectation_CountQueries_MinRows_Threads
    extends SqlExpectation_CountQueries_CountRows_Threads {
        private SqlExpectation_CountQueries_MinRows_Threads(int minQueries, int maxQueries, int minRows, Threads threads) {
            super(minQueries, maxQueries, minRows, Integer.MAX_VALUE, threads);
        }

        public SqlExpectation_CountQueries_CountRows_Threads maxRows(int maxRows) {
            if (maxRows < this.minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_Threads(this.minQueries, this.maxQueries, this.minRows, maxRows, this.threads);
        }
    }

    public static class SqlExpectation_CountQueries_CountRows_Threads
    extends SqlExpectation {
        private SqlExpectation_CountQueries_CountRows_Threads(int minQueries, int maxQueries, int minRows, int maxRows, Threads threads) {
            super(minQueries, maxQueries, minRows, maxRows, threads, SqlStatement.ANY);
        }

        public SqlExpectation type(SqlStatement query) {
            return new SqlExpectation(this.minQueries, this.maxQueries, this.minRows, this.maxRows, this.threads, query);
        }

        public SqlExpectation select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation other() {
            return this.type(SqlStatement.OTHER);
        }
    }

    public static class SqlExpectation_CountRows_Threads
    extends SqlExpectation {
        private SqlExpectation_CountRows_Threads(int minRows, int maxRows, Threads threads) {
            super(0, Integer.MAX_VALUE, minRows, maxRows, threads, SqlStatement.ANY);
        }

        public SqlExpectation_CountRows_Threads_QueryType type(SqlStatement query) {
            return new SqlExpectation_CountRows_Threads_QueryType(this.minRows, this.maxRows, this.threads, query);
        }

        public SqlExpectation_CountRows_Threads_QueryType select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation_CountRows_Threads_QueryType insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation_CountRows_Threads_QueryType update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation_CountRows_Threads_QueryType delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation_CountRows_Threads_QueryType merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation_CountRows_Threads_QueryType other() {
            return this.type(SqlStatement.OTHER);
        }

        public SqlExpectation_CountQueries_CountRows_Threads noneQueries() {
            return this.exactQueries(0);
        }

        public SqlExpectation_CountQueries_CountRows_Threads atMostOneQuery() {
            return this.queriesBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows_Threads exactQueries(int countQueries) {
            return this.queriesBetween(countQueries, countQueries);
        }

        public SqlExpectation_CountQueries_CountRows_Threads queriesBetween(int minQueries, int maxQueries) {
            return new SqlExpectation_CountQueries_CountRows_Threads(minQueries, maxQueries, this.minRows, this.maxRows, this.threads);
        }

        public SqlExpectation_CountRows_MinQueries_Threads minQueries(int minQueries) {
            return new SqlExpectation_CountRows_MinQueries_Threads(this.minRows, this.maxRows, minQueries, this.threads);
        }

        public SqlExpectation_CountRows_MaxQueries_Threads maxQueries(int maxQueries) {
            return new SqlExpectation_CountRows_MaxQueries_Threads(this.minRows, this.maxRows, maxQueries, this.threads);
        }
    }

    public static class SqlExpectation_CountQueries_Threads
    extends SqlExpectation {
        private SqlExpectation_CountQueries_Threads(int minQueries, int maxQueries, Threads threads) {
            super(minQueries, maxQueries, 0, Integer.MAX_VALUE, threads, SqlStatement.ANY);
        }

        public SqlExpectation_CountQueries_Threads_QueryType type(SqlStatement query) {
            return new SqlExpectation_CountQueries_Threads_QueryType(this.minQueries, this.maxQueries, this.threads, query);
        }

        public SqlExpectation_CountQueries_Threads_QueryType select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation_CountQueries_Threads_QueryType insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation_CountQueries_Threads_QueryType update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation_CountQueries_Threads_QueryType delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation_CountQueries_Threads_QueryType merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation_CountQueries_Threads_QueryType other() {
            return this.type(SqlStatement.OTHER);
        }

        public SqlExpectation_CountQueries_CountRows_Threads noneRows() {
            return this.exactRows(0);
        }

        public SqlExpectation_CountQueries_CountRows_Threads atMostOneRow() {
            return this.rowsBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows_Threads exactRows(int countRows) {
            return this.rowsBetween(countRows, countRows);
        }

        public SqlExpectation_CountQueries_CountRows_Threads rowsBetween(int minRows, int maxRows) {
            return new SqlExpectation_CountQueries_CountRows_Threads(this.minQueries, this.maxQueries, minRows, maxRows, this.threads);
        }

        public SqlExpectation_CountQueries_MinRows_Threads minRows(int minRows) {
            return new SqlExpectation_CountQueries_MinRows_Threads(this.minQueries, this.maxQueries, minRows, this.threads);
        }

        public SqlExpectation_CountQueries_MaxRows_Threads maxRows(int maxRows) {
            return new SqlExpectation_CountQueries_MaxRows_Threads(this.minQueries, this.maxQueries, maxRows, this.threads);
        }
    }

    public static class SqlExpectation_CountRows_QueryType
    extends SqlExpectation {
        private SqlExpectation_CountRows_QueryType(int minRows, int maxRows, SqlStatement query) {
            super(0, Integer.MAX_VALUE, minRows, maxRows, Threads.CURRENT, query);
        }

        public SqlExpectation_CountRows_Threads_QueryType threads(Threads threads) {
            return new SqlExpectation_CountRows_Threads_QueryType(this.minRows, this.maxRows, threads, this.type);
        }

        public SqlExpectation_CountRows_Threads_QueryType currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation_CountRows_Threads_QueryType otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation_CountRows_Threads_QueryType anyThreads() {
            return this.threads(Threads.ANY);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType noneQueries() {
            return this.exactQueries(0);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType atMostOneQuery() {
            return this.queriesBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType exactQueries(int countQueries) {
            return this.queriesBetween(countQueries, countQueries);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType queriesBetween(int minQueries, int maxQueries) {
            return new SqlExpectation_CountQueries_CountRows_QueryType(minQueries, maxQueries, this.minRows, this.maxRows, this.type);
        }

        public SqlExpectation_CountRows_MinQueries_QueryType minQueries(int minQueries) {
            return new SqlExpectation_CountRows_MinQueries_QueryType(this.minRows, this.maxRows, minQueries, this.type);
        }

        public SqlExpectation_CountRows_MaxQueries_QueryType maxQueries(int maxQueries) {
            return new SqlExpectation_CountRows_MaxQueries_QueryType(this.minRows, this.maxRows, maxQueries, this.type);
        }
    }

    public static class SqlExpectation_CountRows_MaxQueries_Threads
    extends SqlExpectation_CountQueries_CountRows_Threads {
        private SqlExpectation_CountRows_MaxQueries_Threads(int minRows, int maxRows, int maxQueries, Threads threads) {
            super(0, maxQueries, minRows, maxRows, threads);
        }

        public SqlExpectation_CountQueries_CountRows_Threads minQueries(int minQueries) {
            if (this.maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_Threads(minQueries, this.maxQueries, this.minRows, this.maxRows, this.threads);
        }
    }

    public static class SqlExpectation_CountRows_MinQueries_Threads
    extends SqlExpectation_CountQueries_CountRows_Threads {
        private SqlExpectation_CountRows_MinQueries_Threads(int minRows, int maxRows, int minQueries, Threads threads) {
            super(minQueries, Integer.MAX_VALUE, minRows, maxRows, threads);
        }

        public SqlExpectation_CountQueries_CountRows_Threads maxQueries(int maxQueries) {
            if (maxQueries < this.minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_Threads(this.minQueries, maxQueries, this.minRows, this.maxRows, this.threads);
        }
    }

    public static class SqlExpectation_CountRows_MaxQueries_QueryType
    extends SqlExpectation_CountQueries_CountRows_QueryType {
        private SqlExpectation_CountRows_MaxQueries_QueryType(int minRows, int maxRows, int maxQueries, SqlStatement type) {
            super(0, maxQueries, minRows, maxRows, type);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType minQueries(int minQueries) {
            if (this.maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_QueryType(minQueries, this.maxQueries, this.minRows, this.maxRows, this.type);
        }
    }

    public static class SqlExpectation_CountRows_MinQueries_QueryType
    extends SqlExpectation_CountQueries_CountRows_QueryType {
        private SqlExpectation_CountRows_MinQueries_QueryType(int minRows, int maxRows, int minQueries, SqlStatement type) {
            super(minQueries, Integer.MAX_VALUE, minRows, maxRows, type);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType maxQueries(int maxQueries) {
            if (maxQueries < this.minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_QueryType(this.minQueries, maxQueries, this.minRows, this.maxRows, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_MaxRows_QueryType
    extends SqlExpectation_CountQueries_CountRows_QueryType {
        private SqlExpectation_CountQueries_MaxRows_QueryType(int minQueries, int maxQueries, int maxRows, SqlStatement type) {
            super(minQueries, maxQueries, 0, maxRows, type);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType minRows(int minRows) {
            if (this.maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_QueryType(this.minQueries, this.maxQueries, minRows, this.maxRows, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_MinRows_QueryType
    extends SqlExpectation_CountQueries_CountRows_QueryType {
        private SqlExpectation_CountQueries_MinRows_QueryType(int minQueries, int maxQueries, int minRows, SqlStatement type) {
            super(minQueries, maxQueries, minRows, Integer.MAX_VALUE, type);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType maxRows(int maxRows) {
            if (maxRows < this.minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows_QueryType(this.minQueries, this.maxQueries, this.minRows, maxRows, this.type);
        }
    }

    public static class SqlExpectation_CountQueries_CountRows_QueryType
    extends SqlExpectation {
        private SqlExpectation_CountQueries_CountRows_QueryType(int minQueries, int maxQueries, int minRows, int maxRows, SqlStatement query) {
            super(minQueries, maxQueries, minRows, maxRows, Threads.CURRENT, query);
        }

        public SqlExpectation threads(Threads threads) {
            return new SqlExpectation(this.minQueries, this.maxQueries, this.minRows, this.maxRows, threads, this.type);
        }

        public SqlExpectation currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation anyThreads() {
            return this.threads(Threads.ANY);
        }
    }

    public static class SqlExpectation_CountQueries_QueryType
    extends SqlExpectation {
        private SqlExpectation_CountQueries_QueryType(int minQueries, int maxQueries, SqlStatement query) {
            super(minQueries, maxQueries, 0, Integer.MAX_VALUE, Threads.CURRENT, query);
        }

        public SqlExpectation_CountQueries_Threads_QueryType threads(Threads threads) {
            return new SqlExpectation_CountQueries_Threads_QueryType(this.minQueries, this.maxQueries, threads, this.type);
        }

        public SqlExpectation_CountQueries_Threads_QueryType currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation_CountQueries_Threads_QueryType otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation_CountQueries_Threads_QueryType anyThreads() {
            return this.threads(Threads.ANY);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType noneRows() {
            return this.exactRows(0);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType atMostOneRow() {
            return this.rowsBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType exactRows(int countRows) {
            return this.rowsBetween(countRows, countRows);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType rowsBetween(int minRows, int maxRows) {
            return new SqlExpectation_CountQueries_CountRows_QueryType(this.minQueries, this.maxQueries, minRows, maxRows, this.type);
        }

        public SqlExpectation_CountQueries_MinRows_QueryType minRows(int minRows) {
            return new SqlExpectation_CountQueries_MinRows_QueryType(this.minQueries, this.maxQueries, minRows, this.type);
        }

        public SqlExpectation_CountQueries_MaxRows_QueryType maxRows(int maxRows) {
            return new SqlExpectation_CountQueries_MaxRows_QueryType(this.minQueries, this.maxQueries, maxRows, this.type);
        }
    }

    public static class SqlExpectation_CountRows_MaxQueries
    extends SqlExpectation_CountQueries_CountRows {
        private SqlExpectation_CountRows_MaxQueries(int maxQueries, int minRows, int maxRows) {
            super(0, maxQueries, minRows, maxRows);
        }

        public SqlExpectation_CountQueries_CountRows minQueries(int minQueries) {
            if (this.maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows(minQueries, this.maxQueries, this.minRows, this.maxRows);
        }
    }

    public static class SqlExpectation_CountRows_MinQueries
    extends SqlExpectation_CountQueries_CountRows {
        private SqlExpectation_CountRows_MinQueries(int minQueries, int minRows, int maxRows) {
            super(minQueries, Integer.MAX_VALUE, minRows, maxRows);
        }

        public SqlExpectation_CountQueries_CountRows maxQueries(int maxQueries) {
            if (maxQueries < this.minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows(this.minQueries, maxQueries, this.minRows, this.maxRows);
        }
    }

    public static class SqlExpectation_CountQueries_MaxRows
    extends SqlExpectation_CountQueries_CountRows {
        private SqlExpectation_CountQueries_MaxRows(int minQueries, int maxQueries, int maxRows) {
            super(minQueries, maxQueries, 0, maxRows);
        }

        public SqlExpectation_CountQueries_CountRows minRows(int minRows) {
            if (this.maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows(this.minQueries, this.maxQueries, minRows, this.maxRows);
        }
    }

    public static class SqlExpectation_CountQueries_MinRows
    extends SqlExpectation_CountQueries_CountRows {
        private SqlExpectation_CountQueries_MinRows(int minQueries, int maxQueries, int minRows) {
            super(minQueries, maxQueries, minRows, Integer.MAX_VALUE);
        }

        public SqlExpectation_CountQueries_CountRows maxRows(int maxRows) {
            if (maxRows < this.minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries_CountRows(this.minQueries, this.maxQueries, this.minRows, maxRows);
        }
    }

    public static class SqlExpectation_CountQueries_CountRows
    extends SqlExpectation {
        private SqlExpectation_CountQueries_CountRows(int minQueries, int maxQueries, int minRows, int maxRows) {
            super(minQueries, maxQueries, minRows, maxRows, Threads.CURRENT, SqlStatement.ANY);
            if (minQueries < 0) {
                throw new IllegalArgumentException("min cannot be negative");
            }
            if (maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            if (minRows < 0) {
                throw new IllegalArgumentException("min cannot be negative");
            }
            if (maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
        }

        public SqlExpectation_CountQueries_CountRows_QueryType type(SqlStatement query) {
            return new SqlExpectation_CountQueries_CountRows_QueryType(this.minQueries, this.maxQueries, this.minRows, this.maxRows, query);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation_CountQueries_CountRows_QueryType other() {
            return this.type(SqlStatement.OTHER);
        }

        public SqlExpectation_CountQueries_CountRows_Threads threads(Threads threads) {
            return new SqlExpectation_CountQueries_CountRows_Threads(this.minQueries, this.maxQueries, this.minRows, this.maxRows, threads);
        }

        public SqlExpectation_CountQueries_CountRows_Threads currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation_CountQueries_CountRows_Threads otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation_CountQueries_CountRows_Threads anyThreads() {
            return this.threads(Threads.ANY);
        }
    }

    public static class SqlExpectation_CountRows
    extends SqlExpectation {
        private SqlExpectation_CountRows(int minRows, int maxRows) {
            super(0, Integer.MAX_VALUE, minRows, maxRows, Threads.CURRENT, SqlStatement.ANY);
            if (minRows < 0) {
                throw new IllegalArgumentException("min cannot be negative");
            }
            if (maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
        }

        public SqlExpectation_CountRows_QueryType type(SqlStatement query) {
            return new SqlExpectation_CountRows_QueryType(this.minRows, this.maxRows, query);
        }

        public SqlExpectation_CountRows_QueryType select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation_CountRows_QueryType insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation_CountRows_QueryType update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation_CountRows_QueryType delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation_CountRows_QueryType merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation_CountRows_QueryType other() {
            return this.type(SqlStatement.OTHER);
        }

        public SqlExpectation_CountRows_Threads threads(Threads threads) {
            return new SqlExpectation_CountRows_Threads(this.minRows, this.maxRows, threads);
        }

        public SqlExpectation_CountRows_Threads currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation_CountRows_Threads otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation_CountRows_Threads anyThreads() {
            return this.threads(Threads.ANY);
        }

        public SqlExpectation_CountQueries_CountRows noneQueries() {
            return this.exactQueries(0);
        }

        public SqlExpectation_CountQueries_CountRows atMostOneQuery() {
            return this.queriesBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows exactQueries(int countQueries) {
            return this.queriesBetween(countQueries, countQueries);
        }

        public SqlExpectation_CountQueries_CountRows queriesBetween(int minQueries, int maxQueries) {
            return new SqlExpectation_CountQueries_CountRows(minQueries, maxQueries, this.minRows, this.maxRows);
        }

        public SqlExpectation_CountRows_MinQueries minQueries(int minQueries) {
            return new SqlExpectation_CountRows_MinQueries(minQueries, this.minRows, this.maxRows);
        }

        public SqlExpectation_CountRows_MaxQueries maxQueries(int maxQueries) {
            return new SqlExpectation_CountRows_MaxQueries(maxQueries, this.minRows, this.maxRows);
        }
    }

    public static class SqlExpectation_MaxRows
    extends SqlExpectation_CountRows {
        private SqlExpectation_MaxRows(int maxRows) {
            super(0, maxRows);
        }

        public SqlExpectation_CountRows minRows(int minRows) {
            if (this.maxRows < minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountRows(minRows, this.maxRows);
        }
    }

    public static class SqlExpectation_MinRows
    extends SqlExpectation_CountRows {
        private SqlExpectation_MinRows(int minRows) {
            super(minRows, Integer.MAX_VALUE);
        }

        public SqlExpectation_CountRows maxRows(int maxRows) {
            if (maxRows < this.minRows) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountRows(this.minRows, maxRows);
        }
    }

    public static class SqlExpectation_CountQueries
    extends SqlExpectation {
        private SqlExpectation_CountQueries(int minQueries, int maxQueries) {
            super(minQueries, maxQueries, 0, Integer.MAX_VALUE, Threads.CURRENT, SqlStatement.ANY);
            if (minQueries < 0) {
                throw new IllegalArgumentException("min cannot be negative");
            }
            if (maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
        }

        public SqlExpectation_CountQueries_QueryType type(SqlStatement query) {
            return new SqlExpectation_CountQueries_QueryType(this.minQueries, this.maxQueries, query);
        }

        public SqlExpectation_CountQueries_QueryType select() {
            return this.type(SqlStatement.SELECT);
        }

        public SqlExpectation_CountQueries_QueryType insert() {
            return this.type(SqlStatement.INSERT);
        }

        public SqlExpectation_CountQueries_QueryType update() {
            return this.type(SqlStatement.UPDATE);
        }

        public SqlExpectation_CountQueries_QueryType delete() {
            return this.type(SqlStatement.DELETE);
        }

        public SqlExpectation_CountQueries_QueryType merge() {
            return this.type(SqlStatement.MERGE);
        }

        public SqlExpectation_CountQueries_QueryType other() {
            return this.type(SqlStatement.OTHER);
        }

        public SqlExpectation_CountQueries_Threads threads(Threads threads) {
            return new SqlExpectation_CountQueries_Threads(this.minQueries, this.maxQueries, threads);
        }

        public SqlExpectation_CountQueries_Threads currentThread() {
            return this.threads(Threads.CURRENT);
        }

        public SqlExpectation_CountQueries_Threads otherThreads() {
            return this.threads(Threads.OTHERS);
        }

        public SqlExpectation_CountQueries_Threads anyThreads() {
            return this.threads(Threads.ANY);
        }

        public SqlExpectation_CountQueries_CountRows noneRows() {
            return this.exactRows(0);
        }

        public SqlExpectation_CountQueries_CountRows atMostOneRow() {
            return this.rowsBetween(0, 1);
        }

        public SqlExpectation_CountQueries_CountRows exactRows(int countRows) {
            return this.rowsBetween(countRows, countRows);
        }

        public SqlExpectation_CountQueries_CountRows rowsBetween(int minRows, int maxRows) {
            return new SqlExpectation_CountQueries_CountRows(this.minQueries, this.maxQueries, minRows, maxRows);
        }

        public SqlExpectation_CountQueries_MinRows minRows(int minRows) {
            return new SqlExpectation_CountQueries_MinRows(this.minQueries, this.maxQueries, minRows);
        }

        public SqlExpectation_CountQueries_MaxRows maxRows(int maxRows) {
            return new SqlExpectation_CountQueries_MaxRows(this.minQueries, this.maxQueries, maxRows);
        }
    }

    public static class SqlExpectation_MaxQueries
    extends SqlExpectation_CountQueries {
        private SqlExpectation_MaxQueries(int maxQueries) {
            super(0, maxQueries);
        }

        public SqlExpectation_CountQueries minQueries(int minQueries) {
            if (this.maxQueries < minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries(minQueries, this.maxQueries);
        }
    }

    public static class SqlExpectation_MinQueries
    extends SqlExpectation_CountQueries {
        private SqlExpectation_MinQueries(int minQueries) {
            super(minQueries, Integer.MAX_VALUE);
        }

        public SqlExpectation_CountQueries maxQueries(int maxQueries) {
            if (maxQueries < this.minQueries) {
                throw new IllegalArgumentException("max cannot be less than min");
            }
            return new SqlExpectation_CountQueries(this.minQueries, maxQueries);
        }
    }

    public static class SqlExpectation
    implements Spy.Expectation {
        protected final int minQueries;
        protected final int maxQueries;
        protected final int minRows;
        protected final int maxRows;
        protected final Threads threads;
        protected final SqlStatement type;

        public SqlExpectation(int minQueries, int maxQueries, int minRows, int maxRows, Threads threads, SqlStatement type) {
            this.minQueries = minQueries;
            this.maxQueries = maxQueries;
            this.minRows = minRows;
            this.maxRows = maxRows;
            this.threads = threads;
            this.type = type;
        }

        @Override
        public <T extends Spy<T>> Spy<T> verify(Spy<T> spy) throws SniffyAssertionError {
            int numQueries = 0;
            int numRows = 0;
            for (Map.Entry<StatementMetaData, SqlStats> entry : spy.getExecutedStatements(this.threads, true).entrySet()) {
                if ((SqlStatement.ANY != this.type || SqlStatement.SYSTEM == entry.getKey().query) && this.type != entry.getKey().query) continue;
                SqlStats sqlStats = entry.getValue();
                numQueries += sqlStats.queries.intValue();
                numRows += sqlStats.rows.intValue();
            }
            if (numQueries > this.maxQueries || numQueries < this.minQueries) {
                throw new WrongNumberOfQueriesError(this.threads, this.type, this.minQueries, this.maxQueries, numQueries, spy.getExecutedStatements(this.threads, true).keySet());
            }
            if (numRows > this.maxRows || numRows < this.minRows) {
                throw new WrongNumberOfRowsError(this.threads, this.type, this.minRows, this.maxRows, numRows, spy.getExecutedStatements(this.threads, true));
            }
            return spy;
        }
    }
}

