/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.sql.SqlStatement;
import java.util.regex.Pattern;

public class SqlUtil {
    public static final Pattern NORMALIZE_IN_STATEMENT_PATTERN = Pattern.compile("\\sin\\s*\\((\\s*\\?\\s*,\\s*)++\\?\\s*\\)", 10);

    public static String normalizeInStatement(String sql) {
        return null == sql ? null : NORMALIZE_IN_STATEMENT_PATTERN.matcher(sql).replaceAll(" in (?)").intern();
    }

    public static SqlStatement guessQueryType(String sql) {
        for (int i = 0; i < sql.length(); ++i) {
            if (Character.isWhitespace(sql.charAt(i))) continue;
            if (sql.length() > i + 7) {
                String normalized = sql.substring(i, i + 7).toLowerCase();
                if ("select ".equals(normalized)) {
                    return SqlStatement.SELECT;
                }
                if ("insert ".equals(normalized)) {
                    return SqlStatement.INSERT;
                }
                if ("update ".equals(normalized)) {
                    return SqlStatement.UPDATE;
                }
                if ("delete ".equals(normalized)) {
                    return SqlStatement.DELETE;
                }
            }
            if (sql.length() <= i + 6 || !sql.substring(i, i + 6).equalsIgnoreCase("merge ")) continue;
            return SqlStatement.MERGE;
        }
        return SqlStatement.OTHER;
    }
}

