/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.Sniffer;
import io.sniffy.Sniffy;
import io.sniffy.sql.ResultSetInvocationHandler;
import io.sniffy.sql.SniffyInvocationHandler;
import io.sniffy.sql.StatementMetaData;
import io.sniffy.util.StackTraceExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

class StatementInvocationHandler<T extends Statement>
extends SniffyInvocationHandler<T> {
    private Map<String, Integer> batchedSql;
    StatementMetaData lastStatementMetaData;

    StatementInvocationHandler(T delegate, Connection connectionProxy, String url, String userName) {
        super(connectionProxy, delegate, url, userName);
    }

    @Override
    public Object invokeImpl(T proxy, String methodName, Method method, Object[] args) throws Throwable {
        Object result;
        this.checkConnectionAllowed();
        switch (StatementMethodType.parse(methodName)) {
            case ADD_BATCH: {
                this.addBatch((String)String.class.cast(args[0]));
                result = this.invokeTarget(method, args);
                break;
            }
            case CLEAR_BATCH: {
                this.clearBatch();
                result = this.invokeTarget(method, args);
                break;
            }
            case EXECUTE_BATCH: {
                result = this.invokeTargetAndRecord(method, args, this.getBatchedSql(), true);
                break;
            }
            case EXECUTE_UPDATE: {
                result = this.invokeTargetAndRecord(method, args, null != args && args.length > 0 ? (String)String.class.cast(args[0]) : null, true);
                break;
            }
            case EXECUTE_SQL: {
                result = this.invokeTargetAndRecord(method, args, null != args && args.length > 0 ? (String)String.class.cast(args[0]) : null, false);
                break;
            }
            default: {
                result = this.invokeTarget(method, args);
            }
        }
        return this.proxyResultSet(result);
    }

    protected Object proxyResultSet(Object result) {
        if (result instanceof ResultSet) {
            return Proxy.newProxyInstance(ResultSetInvocationHandler.class.getClassLoader(), new Class[]{ResultSet.class}, new ResultSetInvocationHandler<ResultSet>((ResultSet)result, this.connectionProxy, this.url, this.userName, this.lastStatementMetaData));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeTargetAndRecord(Method method, Object[] args, String sql, boolean isUpdateQuery) throws Throwable {
        Object object;
        long start = System.currentTimeMillis();
        int rowsUpdated = 0;
        try {
            Sniffy.enterJdbcMethod();
            this.checkConnectionAllowed(true);
            Object result = this.invokeTargetImpl(method, args);
            if (isUpdateQuery) {
                Object[] updatedRows;
                if (result instanceof Number) {
                    rowsUpdated = ((Number)result).intValue();
                }
                if (result instanceof int[]) {
                    for (int i : updatedRows = (int[])result) {
                        if (i <= 0) continue;
                        rowsUpdated += i;
                    }
                }
                if (result instanceof long[]) {
                    for (int i : updatedRows = (Object[])((long[])result)) {
                        if (i <= 0L) continue;
                        rowsUpdated = (int)((long)rowsUpdated + i);
                    }
                }
            }
            object = result;
        }
        catch (Throwable throwable) {
            long elapsedTime = System.currentTimeMillis() - start;
            Sniffy.logSqlTime(sql, elapsedTime);
            Sniffy.SniffyMode sniffyMode = Sniffy.getSniffyMode();
            if (sniffyMode.isEnabled()) {
                String stackTrace = sniffyMode.isCaptureStackTraces() ? StackTraceExtractor.printStackTrace(StackTraceExtractor.getTraceForProxiedMethod(method)) : null;
                this.lastStatementMetaData = Sniffy.executeStatement(sql, elapsedTime, stackTrace, rowsUpdated);
            } else {
                Sniffer.executedStatementsGlobalCounter.incrementAndGet();
            }
            throw throwable;
        }
        long elapsedTime = System.currentTimeMillis() - start;
        Sniffy.logSqlTime(sql, elapsedTime);
        Sniffy.SniffyMode sniffyMode = Sniffy.getSniffyMode();
        if (sniffyMode.isEnabled()) {
            String stackTrace = sniffyMode.isCaptureStackTraces() ? StackTraceExtractor.printStackTrace(StackTraceExtractor.getTraceForProxiedMethod(method)) : null;
            this.lastStatementMetaData = Sniffy.executeStatement(sql, elapsedTime, stackTrace, rowsUpdated);
        } else {
            Sniffer.executedStatementsGlobalCounter.incrementAndGet();
        }
        return object;
    }

    protected synchronized void addBatch(String sql) {
        Integer count;
        if (null == sql) {
            return;
        }
        if (null == this.batchedSql) {
            this.batchedSql = new HashMap<String, Integer>();
        }
        if (null != (count = this.batchedSql.get(sql))) {
            this.batchedSql.put(sql, count + 1);
        } else {
            this.batchedSql.put(sql, 1);
        }
    }

    protected synchronized void clearBatch() {
        this.batchedSql = null;
    }

    protected synchronized String getBatchedSql() {
        if (null == this.batchedSql || this.batchedSql.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.batchedSql.entrySet()) {
            if (0 != sb.length()) {
                sb.append("; ");
            }
            Integer times = entry.getValue();
            sb.append(entry.getKey());
            if (times <= 1) continue;
            sb.append(" /*").append(times).append(" times*/");
        }
        return sb.toString();
    }

    protected static enum StatementMethodType {
        EXECUTE_SQL,
        EXECUTE_UPDATE,
        ADD_BATCH,
        CLEAR_BATCH,
        EXECUTE_BATCH,
        OTHER;


        static StatementMethodType parse(String methodName) {
            if ("execute".equals(methodName) || "executeQuery".equals(methodName)) {
                return EXECUTE_SQL;
            }
            if ("executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName)) {
                return EXECUTE_UPDATE;
            }
            if ("addBatch".equals(methodName)) {
                return ADD_BATCH;
            }
            if ("clearBatch".equals(methodName)) {
                return CLEAR_BATCH;
            }
            if ("executeBatch".equals(methodName) || "executeLargeBatch".equals(methodName)) {
                return EXECUTE_BATCH;
            }
            return OTHER;
        }
    }
}

