/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.sql;

import io.sniffy.SniffyAssertionError;
import io.sniffy.Threads;
import io.sniffy.sql.SqlStatement;
import io.sniffy.sql.SqlStats;
import io.sniffy.sql.StatementMetaData;
import io.sniffy.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WrongNumberOfRowsError
extends SniffyAssertionError {
    private final Threads threadMatcher;
    private final SqlStatement query;
    private final int minimumRows;
    private final int maximumRows;
    private final int numRows;
    private final Map<StatementMetaData, SqlStats> executedStatements;

    public WrongNumberOfRowsError(Threads threadMatcher, SqlStatement query, int minimumRows, int maximumQueries, int numRows, Map<StatementMetaData, SqlStats> executedStatements) {
        super(WrongNumberOfRowsError.buildDetailMessage(threadMatcher, query, minimumRows, maximumQueries, numRows, executedStatements));
        this.threadMatcher = threadMatcher;
        this.query = query;
        this.minimumRows = minimumRows;
        this.maximumRows = maximumQueries;
        this.numRows = numRows;
        this.executedStatements = Collections.unmodifiableMap(executedStatements);
    }

    public Threads getThreadMatcher() {
        return this.threadMatcher;
    }

    public SqlStatement getQuery() {
        return this.query;
    }

    public int getMinimumRows() {
        return this.minimumRows;
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public Collection<StatementMetaData> getExecutedStatements() {
        return this.executedStatements.keySet();
    }

    public List<String> getExecutedSqls() {
        ArrayList<String> executedSqls = new ArrayList<String>(this.executedStatements.size());
        for (StatementMetaData statement : this.executedStatements.keySet()) {
            executedSqls.add(statement.sql);
        }
        return executedSqls;
    }

    private static String buildDetailMessage(Threads threadMatcher, SqlStatement query, int minimumQueries, int maximumQueries, int numQueries, Map<StatementMetaData, SqlStats> executedStatements) {
        StringBuilder sb = new StringBuilder();
        sb.append("Expected between ").append(minimumQueries).append(" and ").append(maximumQueries);
        threadMatcher.describe(sb);
        query.describe(sb);
        sb.append(" rows ");
        sb.append(StringUtil.LINE_SEPARATOR);
        sb.append("Observed ").append(numQueries).append(" rows instead:");
        sb.append(StringUtil.LINE_SEPARATOR);
        if (null != executedStatements) {
            for (Map.Entry<StatementMetaData, SqlStats> entry : executedStatements.entrySet()) {
                StatementMetaData statement = entry.getKey();
                SqlStats sqlStats = entry.getValue();
                if (SqlStatement.ANY != query && null != query && statement.query != query) continue;
                sb.append(statement.sql).append("; /* ").append(sqlStats.rows).append(" rows */").append(StringUtil.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }
}

