/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import io.sniffy.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExceptionUtil {
    private static final Method addSuppressedMethod = ExceptionUtil.getAddSuppressedMethod();

    protected ExceptionUtil() {
    }

    private static Method getAddSuppressedMethod() {
        try {
            Class<Throwable> throwableClass = Throwable.class;
            return throwableClass.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean throwException(String className, String message) {
        try {
            Class<Throwable> throwableClass = ExceptionUtil.forName(className);
            Constructor<Throwable> constructor = throwableClass.getConstructor(String.class);
            Throwable throwable = constructor.newInstance(message);
            ExceptionUtil.throwException(throwable);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private static Class<Throwable> forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static RuntimeException throwException(Throwable e) {
        ExceptionUtil.throwAny(e);
        return new RuntimeException(e);
    }

    private static <E extends Throwable> void throwAny(Throwable e) throws E {
        throw e;
    }

    public static boolean addSuppressed(Throwable e, Throwable suppressed) {
        if (null == addSuppressedMethod) {
            return false;
        }
        try {
            addSuppressedMethod.invoke((Object)e, suppressed);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return true;
    }

    public static String generateMessage(String s, StackTraceElement[] closeStackTrace) {
        StringBuilder sb = new StringBuilder(s);
        for (StackTraceElement traceElement : closeStackTrace) {
            sb.append(StringUtil.LINE_SEPARATOR).append("\tat ").append(traceElement);
        }
        return sb.toString();
    }

    public static void throwTargetException(InvocationTargetException ite) {
        Throwable targetException = ite.getTargetException();
        if (null == targetException) {
            targetException = ite;
        }
        ExceptionUtil.throwException(targetException);
    }

    public static RuntimeException processException(Throwable e) {
        if (null != e) {
            if (e instanceof InvocationTargetException) {
                ExceptionUtil.throwTargetException((InvocationTargetException)e);
            } else {
                ExceptionUtil.throwException(e);
            }
        }
        return new RuntimeException(e);
    }
}

