/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import io.sniffy.util.ObjectWrapper;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ObjectWrapperFieldUpdater<C, O>
extends AtomicReferenceFieldUpdater<C, O> {
    private final AtomicReferenceFieldUpdater<C, O> defaultFieldUpdater;

    public ObjectWrapperFieldUpdater(AtomicReferenceFieldUpdater<C, O> defaultFieldUpdater) {
        this.defaultFieldUpdater = defaultFieldUpdater;
    }

    private boolean isWrappedObject(C wrapper) {
        return wrapper instanceof ObjectWrapper;
    }

    private C getWrappedObject(C wrapper) {
        return (C)((ObjectWrapper)wrapper).getDelegate();
    }

    @Override
    public O getAndSet(C obj, O newValue) {
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.getAndSet(obj, newValue);
            return this.defaultFieldUpdater.getAndSet(this.getWrappedObject(obj), newValue);
        }
        return this.defaultFieldUpdater.getAndSet(obj, newValue);
    }

    @Override
    public boolean compareAndSet(C obj, O expect, O update) {
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.compareAndSet(obj, expect, update);
            return this.defaultFieldUpdater.compareAndSet(this.getWrappedObject(obj), expect, update);
        }
        return this.defaultFieldUpdater.compareAndSet(obj, expect, update);
    }

    @Override
    public boolean weakCompareAndSet(C obj, O expect, O update) {
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.weakCompareAndSet(obj, expect, update);
            return this.defaultFieldUpdater.weakCompareAndSet(this.getWrappedObject(obj), expect, update);
        }
        return this.defaultFieldUpdater.weakCompareAndSet(obj, expect, update);
    }

    @Override
    public void set(C obj, O newValue) {
        this.defaultFieldUpdater.set(obj, newValue);
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.set(this.getWrappedObject(obj), newValue);
        }
    }

    @Override
    public void lazySet(C obj, O newValue) {
        this.defaultFieldUpdater.lazySet(obj, newValue);
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.lazySet(this.getWrappedObject(obj), newValue);
        }
    }

    @Override
    public O get(C obj) {
        if (this.isWrappedObject(obj)) {
            this.defaultFieldUpdater.get(obj);
            return this.defaultFieldUpdater.get(this.getWrappedObject(obj));
        }
        return this.defaultFieldUpdater.get(obj);
    }
}

