/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import io.sniffy.util.ReflectionFieldCopier;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReflectionCopier<T> {
    private final ReflectionFieldCopier[] reflectionFieldCopiers;

    public ReflectionCopier(Class<? extends T> clazz) {
        this(clazz, Collections.emptySet());
    }

    public ReflectionCopier(Class<? extends T> clazz, String ... ignoreFieldName) {
        this(clazz, new HashSet<String>(Arrays.asList(ignoreFieldName)));
    }

    public ReflectionCopier(Class<? extends T> clazz, Set<String> ignoreFieldNames) {
        ArrayList<ReflectionFieldCopier> reflectionFieldCopiers = new ArrayList<ReflectionFieldCopier>();
        for (Class<T> superClass = clazz; null != superClass && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            for (Field declaredField : superClass.getDeclaredFields()) {
                if (null != ignoreFieldNames && ignoreFieldNames.contains(declaredField.getName()) || declaredField.isSynthetic() || Modifier.isStatic(declaredField.getModifiers())) continue;
                reflectionFieldCopiers.add(new ReflectionFieldCopier(superClass, declaredField.getName()));
            }
        }
        this.reflectionFieldCopiers = reflectionFieldCopiers.toArray(new ReflectionFieldCopier[0]);
    }

    public void copy(T from, T to) {
        for (ReflectionFieldCopier reflectionFieldCopier : this.reflectionFieldCopiers) {
            reflectionFieldCopier.copy(from, to);
        }
    }
}

