/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import io.sniffy.util.ExceptionUtil;
import io.sniffy.util.JVMUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;
import java.util.concurrent.locks.Lock;
import sun.misc.Unsafe;

public class ReflectionUtil {
    public static final Unsafe UNSAFE;

    public static boolean setAccessible(AccessibleObject ao) {
        if (JVMUtil.getVersion() >= 16) {
            try {
                long overrideOffset = UNSAFE.objectFieldOffset(FakeAccessibleObject.class.getDeclaredField("override"));
                UNSAFE.putBoolean(ao, overrideOffset, true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return ao.isAccessible();
        }
        ao.setAccessible(true);
        return true;
    }

    public static <T, V> boolean setField(String className, T instance, String fieldName, V value) {
        return ReflectionUtil.setField(className, instance, fieldName, value, null);
    }

    public static <T, V> boolean setField(String className, T instance, String fieldName, V value, String lockFieldName) {
        try {
            return ReflectionUtil.setField(Class.forName(className), instance, fieldName, value, lockFieldName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T, V> boolean setField(Class<T> clazz, T instance, String fieldName, V value) {
        return ReflectionUtil.setField(clazz, instance, fieldName, value, null);
    }

    public static <T, V> boolean setFields(String className, T instance, Class<V> valueClass, V value) {
        try {
            return ReflectionUtil.setFields(Class.forName(className), instance, valueClass, value);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T, V> boolean setFields(Class<T> clazz, T instance, Class<V> valueClass, V value) {
        boolean fieldsFound = false;
        boolean result = true;
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(valueClass)) continue;
            fieldsFound = true;
            result = result && ReflectionUtil.setField(clazz, instance, field.getName(), value, null);
        }
        return fieldsFound && result;
    }

    public static <T, V> boolean setFirstField(Class<T> clazz, T instance, Class<V> valueClass, V value) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(valueClass)) continue;
            return ReflectionUtil.setField(clazz, instance, field.getName(), value, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, V> boolean setField(Class<T> clazz, T instance, String fieldName, V value, String lockFieldName) {
        try {
            Object lockObject;
            Field instanceField = clazz.getDeclaredField(fieldName);
            if (!instanceField.isAccessible()) {
                ReflectionUtil.setAccessible(instanceField);
            }
            Field modifiersField = ReflectionUtil.getModifiersField();
            ReflectionUtil.setAccessible(modifiersField);
            modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
            if (null == lockFieldName) {
                instanceField.set(instance, value);
                return true;
            }
            Field lockField = clazz.getDeclaredField(lockFieldName);
            if (!lockField.isAccessible()) {
                ReflectionUtil.setAccessible(lockField);
            }
            if (!((lockObject = lockField.get(instance)) instanceof Lock)) {
                Object object = lockObject;
                synchronized (object) {
                    instanceField.set(instance, value);
                    return true;
                }
            }
            Lock lock = (Lock)lockObject;
            try {
                lock.lock();
                instanceField.set(instance, value);
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static <T, V> V getField(String className, T instance, String fieldName) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        return ReflectionUtil.getField(className, instance, fieldName, null);
    }

    public static <T, V> V getField(String className, T instance, String fieldName, String lockFieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return ReflectionUtil.getField(Class.forName(className), instance, fieldName, lockFieldName);
    }

    public static <T, V> V getField(Class<T> clazz, T instance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        V field = ReflectionUtil.getField(clazz, instance, fieldName, null);
        return field;
    }

    public static <T, V> V getFirstField(String className, T instance, Class<V> valueClass) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return ReflectionUtil.getFirstField(Class.forName(className), instance, valueClass);
    }

    public static <T, V> V getFirstField(Class<T> clazz, T instance, Class<V> valueClass) throws NoSuchFieldException, IllegalAccessException {
        V resultField = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(valueClass)) continue;
            resultField = ReflectionUtil.getField(clazz, instance, field.getName(), null);
        }
        return resultField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> V getField(Class<T> clazz, T instance, String fieldName, String lockFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field instanceField = clazz.getDeclaredField(fieldName);
        if (!instanceField.isAccessible()) {
            ReflectionUtil.setAccessible(instanceField);
        }
        Field modifiersField = ReflectionUtil.getModifiersField();
        ReflectionUtil.setAccessible(modifiersField);
        modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
        if (null != lockFieldName) {
            Object lockObject;
            Field lockField = clazz.getDeclaredField(lockFieldName);
            if (!lockField.isAccessible()) {
                lockField.setAccessible(true);
            }
            if ((lockObject = lockField.get(instance)) instanceof Lock) {
                Lock lock = (Lock)lockObject;
                try {
                    lock.lock();
                    Object object = instanceField.get(instance);
                    return (V)object;
                }
                finally {
                    lock.unlock();
                }
            }
            Object object = lockObject;
            synchronized (object) {
                return (V)instanceField.get(instance);
            }
        }
        return (V)instanceField.get(instance);
    }

    private static Field getModifiersField() throws NoSuchFieldException {
        try {
            return Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                ReflectionUtil.setAccessible(getDeclaredFields0);
                for (Field field : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(field.getName())) continue;
                    return field;
                }
            }
            catch (Exception ex) {
                ExceptionUtil.addSuppressed(e, ex);
            }
            throw e;
        }
    }

    public static <R, T> R invokeMethod(Class<T> clazz, T instance, String methodName, Class<R> returnClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (R)ReflectionUtil.invokeMethod(clazz, instance, methodName);
    }

    public static Object invokeMethod(Class<?> clazz, Object instance, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectionUtil.method(clazz, methodName, new Class[0]).invoke(instance, new Object[0]);
    }

    public static <R, T, P1> R invokeMethod(Class<T> clazz, T instance, String methodName, Class<P1> argument1Type, P1 argument1, Class<R> returnClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (R)ReflectionUtil.invokeMethod(clazz, instance, methodName, argument1Type, argument1);
    }

    public static <P1> Object invokeMethod(Class<?> clazz, Object instance, String methodName, Class<P1> argument1Type, Object argument1) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectionUtil.method(clazz, methodName, argument1Type);
        return method.invoke(instance, argument1);
    }

    public static <R, T, P1, P2> R invokeMethod(Class<T> clazz, T instance, String methodName, Class<P1> argument1Type, P1 argument1, Class<P2> argument2Type, P2 argument2, Class<R> returnClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (R)ReflectionUtil.invokeMethod(clazz, instance, methodName, argument1Type, argument1, argument2Type, argument2);
    }

    public static <P1, P2> Object invokeMethod(Class<?> clazz, Object instance, String methodName, Class<P1> argument1Type, Object argument1, Class<P2> argument2Type, Object argument2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectionUtil.method(clazz, methodName, argument1Type, argument2Type);
        return method.invoke(instance, argument1, argument2);
    }

    public static <R, T, P1, P2, P3> R invokeMethod(Class<T> clazz, T instance, String methodName, Class<P1> argument1Type, P1 argument1, Class<P2> argument2Type, P2 argument2, Class<P3> argument3Type, P3 argument3, Class<R> returnClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (R)ReflectionUtil.invokeMethod(clazz, instance, methodName, argument1Type, argument1, argument2Type, argument2, argument3Type, argument3);
    }

    public static <P1, P2, P3> Object invokeMethod(Class<?> clazz, Object instance, String methodName, Class<P1> argument1Type, Object argument1, Class<P2> argument2Type, Object argument2, Class<P3> argument3Type, Object argument3) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectionUtil.method(clazz, methodName, argument1Type, argument2Type, argument3Type);
        return method.invoke(instance, argument1, argument2, argument3);
    }

    public static Method method(Class<?> clazz, String methodName, Class<?> ... argumentTypes) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(methodName, argumentTypes);
        ReflectionUtil.setAccessible(method);
        return method;
    }

    static {
        Unsafe unsafe = null;
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UNSAFE = unsafe;
    }

    private static class FakeAccessibleObject
    implements AnnotatedElement {
        private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
        boolean override;
        static final Object reflectionFactory = new Object();
        volatile Object securityCheckCache;

        private FakeAccessibleObject() {
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    }
}

