/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StackTraceExtractor {
    private StackTraceExtractor() {
    }

    public static List<StackTraceElement> getTraceForProxiedMethod(Method method) throws ClassNotFoundException {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Class<?> baseClass = method.getDeclaringClass();
        int startIndex = 0;
        StackTraceElement baseMethodTrace = null;
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement traceElement = stackTraceElements[i];
            String traceElementClassName = traceElement.getClassName();
            if (!traceElementClassName.contains("$Proxy") || !baseClass.isAssignableFrom(Class.forName(traceElementClassName))) continue;
            baseMethodTrace = StackTraceExtractor.createTraceElement(method, traceElement);
            startIndex = i + 1;
            break;
        }
        if (startIndex == 0) {
            return Arrays.asList(stackTraceElements);
        }
        return StackTraceExtractor.replaceStackTraceElements(stackTraceElements, startIndex, baseMethodTrace);
    }

    private static List<StackTraceElement> replaceStackTraceElements(StackTraceElement[] stackTraceElements, int startIndex, StackTraceElement baseMethodTrace) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        result.add(baseMethodTrace);
        result.addAll(Arrays.asList(Arrays.copyOfRange(stackTraceElements, startIndex, stackTraceElements.length - 1)));
        return result;
    }

    public static List<StackTraceElement> getTraceForImplementingMethod(Method method, Method methodImpl) throws ClassNotFoundException {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String implClassName = methodImpl.getDeclaringClass().getCanonicalName();
        String implMethodName = methodImpl.getName();
        int startIndex = 0;
        StackTraceElement baseMethodTrace = null;
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement traceElement = stackTraceElements[i];
            if (!traceElement.getClassName().equals(implClassName) || !traceElement.getMethodName().equals(implMethodName)) continue;
            baseMethodTrace = StackTraceExtractor.createTraceElement(method, traceElement);
            startIndex = i + 1;
            break;
        }
        if (startIndex == 0) {
            return Arrays.asList(stackTraceElements);
        }
        return StackTraceExtractor.replaceStackTraceElements(stackTraceElements, startIndex, baseMethodTrace);
    }

    public static List<StackTraceElement> getTraceTillPackage(String packageName) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int startIndex = 0;
        for (int i = 1; i < stackTraceElements.length; ++i) {
            StackTraceElement traceElement = stackTraceElements[i];
            String traceElementClassName = traceElement.getClassName();
            if (traceElementClassName.startsWith(packageName) || traceElementClassName.startsWith("java") || traceElementClassName.startsWith("com.sun") || traceElementClassName.startsWith("sun") || "io.sniffy.Sniffy".equals(traceElementClassName) || "io.sniffy.socket.SnifferSocketImpl".equals(traceElementClassName) || "io.sniffy.socket.CompatSnifferSocketImpl".equals(traceElementClassName) || "io.sniffy.socket.SnifferInputStream".equals(traceElementClassName) || "io.sniffy.socket.SnifferOutputStream".equals(traceElementClassName) || "io.sniffy.util.StackTraceExtractor".equals(traceElementClassName)) continue;
            startIndex = i > 1 ? i - 1 : i;
            break;
        }
        if (startIndex <= 0) {
            return Arrays.asList(stackTraceElements);
        }
        return Arrays.asList(Arrays.copyOfRange(stackTraceElements, startIndex, stackTraceElements.length - 1));
    }

    public static String printStackTrace(List<StackTraceElement> stackTraceElements) {
        if (stackTraceElements == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            sb.append(stackTraceElement.toString()).append(lineSeparator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    private static StackTraceElement createTraceElement(Method method, StackTraceElement baseTraceElement) {
        return new StackTraceElement(method.getDeclaringClass().getCanonicalName(), method.getName(), baseTraceElement.getFileName(), baseTraceElement.getLineNumber());
    }

    public static boolean hasClassInStackTrace(String className) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasClassAndMethodInStackTrace(String className, String methodName) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith(className) || !ste.getMethodName().startsWith(methodName)) continue;
            return true;
        }
        return false;
    }
}

