/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class StringUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String escapeJsonString(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (i > 0 && string.charAt(i - 1) == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String[] splitByLastSlashAndDecode(String connectionString) throws UnsupportedEncodingException {
        int lastIndexOf = connectionString.lastIndexOf("/");
        if (lastIndexOf >= 0) {
            return new String[]{StringUtil.doubleURLDecode(connectionString.substring(0, lastIndexOf)), lastIndexOf + 1 >= connectionString.length() ? "" : StringUtil.doubleURLDecode(connectionString.substring(lastIndexOf + 1))};
        }
        return new String[]{StringUtil.doubleURLDecode(connectionString)};
    }

    public static String doubleURLDecode(String string) throws UnsupportedEncodingException {
        return URLDecoder.decode(URLDecoder.decode(string, "UTF-8"), "UTF-8");
    }
}

