/*
 * Decompiled with CFR 0.152.
 */
package io.sniffy.test.junit;

import io.sniffy.Executable;
import io.sniffy.Expectation;
import io.sniffy.Expectations;
import io.sniffy.NoQueriesAllowed;
import io.sniffy.Sniffy;
import io.sniffy.Spy;
import io.sniffy.configuration.SniffyConfiguration;
import io.sniffy.registry.ConnectionsRegistry;
import io.sniffy.socket.AddressMatchers;
import io.sniffy.socket.DisableSockets;
import io.sniffy.socket.NoSocketsAllowed;
import io.sniffy.socket.SocketExpectation;
import io.sniffy.socket.SocketExpectations;
import io.sniffy.socket.TcpConnections;
import io.sniffy.sql.NoSql;
import io.sniffy.sql.SqlExpectation;
import io.sniffy.sql.SqlExpectations;
import io.sniffy.sql.SqlQueries;
import io.sniffy.test.AnnotationProcessor;
import io.sniffy.test.Count;
import io.sniffy.util.Range;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SniffyRule
implements TestRule {
    public Statement apply(Statement statement, Description description) {
        List<SocketExpectation> socketExpectationList;
        List<SqlExpectation> expectationList;
        try {
            expectationList = SniffyRule.buildSqlExpectationList(description);
        }
        catch (IllegalArgumentException e) {
            return new InvalidAnnotationsStatement(statement, e);
        }
        try {
            socketExpectationList = SniffyRule.buildSocketExpectationList(description);
        }
        catch (IllegalArgumentException e) {
            return new InvalidAnnotationsStatement(statement, e);
        }
        DisableSockets disableSockets = (DisableSockets)description.getAnnotation(DisableSockets.class);
        if (!expectationList.isEmpty() || !socketExpectationList.isEmpty() || null != disableSockets) {
            return new SnifferStatement(statement, expectationList, socketExpectationList, disableSockets);
        }
        return statement;
    }

    private static List<SocketExpectation> buildSocketExpectationList(Description description) {
        SocketExpectation socketExpectation = (SocketExpectation)description.getAnnotation(SocketExpectation.class);
        SocketExpectations socketExpectations = (SocketExpectations)description.getAnnotation(SocketExpectations.class);
        NoSocketsAllowed noSocketsAllowed = (NoSocketsAllowed)description.getAnnotation(NoSocketsAllowed.class);
        Class testClass = description.getTestClass();
        while (null == socketExpectations && null == socketExpectation && null == noSocketsAllowed && !Object.class.equals((Object)testClass)) {
            socketExpectations = testClass.getAnnotation(SocketExpectations.class);
            socketExpectation = testClass.getAnnotation(SocketExpectation.class);
            noSocketsAllowed = testClass.getAnnotation(NoSocketsAllowed.class);
            testClass = testClass.getSuperclass();
        }
        return AnnotationProcessor.buildSocketExpectationList((SocketExpectation)socketExpectation, (SocketExpectations)socketExpectations, (NoSocketsAllowed)noSocketsAllowed);
    }

    private static List<SqlExpectation> buildSqlExpectationList(Description description) {
        SqlExpectations sqlExpectations = (SqlExpectations)description.getAnnotation(SqlExpectations.class);
        SqlExpectation sqlExpectation = (SqlExpectation)description.getAnnotation(SqlExpectation.class);
        NoSql noSql = (NoSql)description.getAnnotation(NoSql.class);
        if (null == sqlExpectations) {
            sqlExpectations = Expectations.SqlExpectationsAdapter.adapter((Expectations)((Expectations)description.getAnnotation(Expectations.class)));
        }
        if (null == sqlExpectation) {
            sqlExpectation = Expectation.SqlExpectationAdapter.adapter((Expectation)((Expectation)description.getAnnotation(Expectation.class)));
        }
        if (null == noSql && null != description.getAnnotation(NoQueriesAllowed.class)) {
            noSql = ((NoQueriesAllowed)description.getAnnotation(NoQueriesAllowed.class)).annotationType().getAnnotation(NoSql.class);
        }
        return AnnotationProcessor.buildSqlExpectationList((Class)description.getTestClass(), (SqlExpectations)sqlExpectations, (SqlExpectation)sqlExpectation, (NoSql)noSql);
    }

    static {
        SniffyConfiguration.INSTANCE.setMonitorSocket(true);
        SniffyConfiguration.INSTANCE.setMonitorNio(true);
        Sniffy.initialize();
    }

    private static class SnifferStatement
    extends Statement {
        private final Statement delegate;
        private final List<SqlExpectation> sqlExpectationList;
        private final List<SocketExpectation> socketExpectationList;
        private final DisableSockets disableSockets;

        public SnifferStatement(Statement delegate, List<SqlExpectation> sqlExpectationList, List<SocketExpectation> socketExpectationList, DisableSockets disableSockets) {
            this.delegate = delegate;
            this.sqlExpectationList = sqlExpectationList;
            this.socketExpectationList = socketExpectationList;
            this.disableSockets = disableSockets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            Spy spy = Sniffy.spy();
            if (null != this.sqlExpectationList) {
                for (SqlExpectation sqlExpectation : this.sqlExpectationList) {
                    spy = spy.expect((Spy.Expectation)new SqlQueries.SqlExpectation(Range.parse((Count)sqlExpectation.count()).min, Range.parse((Count)sqlExpectation.count()).max, Range.parse((Count)sqlExpectation.rows()).min, Range.parse((Count)sqlExpectation.rows()).max, sqlExpectation.threads(), sqlExpectation.query()));
                }
            }
            if (null != this.socketExpectationList) {
                for (SocketExpectation socketExpectation : this.socketExpectationList) {
                    spy = spy.expect((Spy.Expectation)new TcpConnections.TcpExpectation(Range.parse((Count)socketExpectation.connections()).min, Range.parse((Count)socketExpectation.connections()).max, socketExpectation.threads(), "".equals(socketExpectation.hostName()) ? null : AddressMatchers.exactAddressMatcher((String)socketExpectation.hostName())));
                }
            }
            try {
                if (null != this.disableSockets) {
                    ConnectionsRegistry.INSTANCE.setSocketAddressStatus(null, null, Integer.valueOf(-1));
                }
                spy.execute(new Executable(){

                    public void execute() throws Throwable {
                        SnifferStatement.this.delegate.evaluate();
                    }
                }).close();
            }
            finally {
                if (null != this.disableSockets) {
                    ConnectionsRegistry.INSTANCE.clear();
                }
            }
        }
    }

    private static class InvalidAnnotationsStatement
    extends Statement {
        private final Statement delegate;
        private final Throwable exception;

        public InvalidAnnotationsStatement(Statement delegate, Throwable exception) {
            this.delegate = delegate;
            this.exception = exception;
        }

        public void evaluate() throws Throwable {
            try {
                this.delegate.evaluate();
            }
            finally {
                throw this.exception;
            }
        }
    }
}

